
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
months = np.arange(1, 13)
visitors = np.random.randint(1000, 5000, size=12)
conversion_rate = np.random.uniform(0.01, 0.05, size=12)

# Axes Limits and Labels
xlabel_value = "Months"
xlim_values = [0, 13]
xticks_values = np.arange(1, 13, 1)

ylabel_visitors = "Number of Visitors"
ylim_visitors = [0, 6000]
yticks_visitors = np.arange(0, 6001, 1000)

ylabel_conversion = "Conversion Rate (%)"
ylim_conversion = [0, 6]
yticks_conversion = np.arange(0, 6.1, 1)

# Labels
label_visitors = "Number of Visitors"
label_conversion = "Conversion Rate"

# Titles
title = "Website Traffic Trends Over a Year"
legend_title = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot visitors data
color_visitors = "#1f77b4"  # Blue color
ax1.plot(
    months,
    visitors,
    marker="o",
    color=color_visitors,
    linewidth=2,
    markersize=6,
    markerfacecolor=color_visitors,
    label=label_visitors,
)

ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_visitors, fontsize=14, color=color_visitors)
ax1.set_xticks(xticks_values)
ax1.set_xlim(xlim_values)
ax1.set_yticks(yticks_visitors)
ax1.set_ylim(ylim_visitors)
ax1.tick_params(axis="y", labelcolor=color_visitors)

# Create a twin y-axis to plot conversion rate
ax2 = ax1.twinx()
color_conversion = "#2ca02c"  # Green color
ax2.plot(
    months,
    conversion_rate * 100,
    linestyle="--",
    marker="x",
    color=color_conversion,
    linewidth=2,
    markersize=6,
    markerfacecolor=color_conversion,
    label=label_conversion,
)

ax2.set_ylabel(ylabel_conversion, fontsize=14, color=color_conversion)
ax2.set_yticks(yticks_conversion)
ax2.set_ylim(ylim_conversion)
ax2.tick_params(axis="y", labelcolor=color_conversion)

# Set the title
ax1.set_title(title, fontsize=20)

# Add a legend with a title
fig.legend(
    loc="upper left",
    fontsize=12,
    title=legend_title,
    title_fontsize=12,
    bbox_to_anchor=(0.1, 0.95),
)

# Change the plot background color
ax1.set_facecolor("#f5f5f5")
ax2.set_facecolor("#f5f5f5")

# Show grid with lighter color
ax1.grid(True, color="#e1e1e1", linewidth=1.5)

# Change the axis colors
ax1.spines["bottom"].set_color("#ffffff")
ax1.spines["top"].set_color("#ffffff")
ax1.spines["left"].set_color("#ffffff")
ax1.spines["right"].set_color("#ffffff")
ax2.spines["bottom"].set_color("#ffffff")
ax2.spines["top"].set_color("#ffffff")
ax2.spines["left"].set_color("#ffffff")
ax2.spines["right"].set_color("#ffffff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_164.pdf", bbox_inches="tight")
