
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Setting seed for reproducibility

# Data for plotting
campaigns = ["Campaign A", "Campaign B", "Campaign C", "Campaign D"]
engagement_rate_instagram = [0.12, 0.15, 0.18, 0.20]
engagement_rate_facebook = [0.25, 0.27, 0.30, 0.32]

# Axes Limits and Labels
xlabel_value = "Marketing Campaigns"
xlim_values = [-0.5, 3.5]
xticks_values = range(len(campaigns))
xticks_labels = campaigns

ylabel_value = "Engagement Rate"
ylim_values = [0.10, 0.35]
yticks_values = np.arange(0.10, 0.36, 0.05)

# Labels
label_instagram = "Instagram"
label_facebook = "Facebook"

# Titles
title_1 = "Social Media Engagement Rates"
title_2 = "Platforms"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax = plt.subplots(figsize=(10, 6))

# Plot Instagram Engagement Rate
ax.plot(
    campaigns,
    engagement_rate_instagram,
    marker="o",
    color="#1f77b4",  # Blue color for Instagram
    linewidth=2,
    markersize=8,
    markerfacecolor="#1f77b4",
    label=label_instagram,
)

# Plot Facebook Engagement Rate
ax.plot(
    campaigns,
    engagement_rate_facebook,
    marker="s",
    color="#ff7f0e",  # Orange color for Facebook
    linewidth=2,
    markersize=8,
    markerfacecolor="#ff7f0e",
    linestyle='--',
    label=label_facebook,
)

# Set the x and y ticks and labels
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)
plt.xticks(xticks_values, xticks_labels, fontsize=12)
plt.xlim(xlim_values)

# Set the title and labels
ax.set_title(title_1, fontsize=20, fontweight='bold')
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove tick lines outside the plotting area
ax.tick_params(axis="both", which="both", length=0)

# Add a legend with a title
ax.legend(
    title=title_2,
    loc="upper left",
    fontsize=12,
    title_fontsize=12,
    edgecolor="#fdfdfd",
)

# Change the plot background color
ax.set_facecolor("#eaeaf2")

# Show grid with lighter color
ax.grid(True, color="#dcdcdc", linewidth=1.5)

# Change the axis colors
ax.spines["bottom"].set_color("#ffffff")
ax.spines["top"].set_color("#ffffff")
ax.spines["left"].set_color("#ffffff")
ax.spines["right"].set_color("#ffffff")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_165.pdf", bbox_inches="tight")
