
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
training_data_size = [100, 500, 1000, 5000]
accuracy_model_A = [0.65, 0.75, 0.80, 0.85]
accuracy_model_B = [0.60, 0.68, 0.74, 0.82]

# Axes Limits and Labels
xlabel_value = "Training Data Size (in thousands)"
xlim_values = [0, 6000]
xticks_values = np.arange(0, 5001, 1000)

ylabel_value = "Accuracy"
ylim_values = [0.55, 0.90]
yticks_values = np.arange(0.55, 0.91, 0.05)

# Labels
label_model_A = "Model A"
label_model_B = "Model B"

# Titles
title_1 = "AI Model Performance vs Training Data Size"
title_2 = "Model Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and the line that we will manipulate
fig, ax = plt.subplots(figsize=(10, 6))
ax.plot(
    training_data_size,
    accuracy_model_A,
    marker="s",
    color="#1f77b4",
    linewidth=2,
    markersize=8,
    markerfacecolor="#1f77b4",
    label=label_model_A,
)

ax.plot(
    training_data_size,
    accuracy_model_B,
    marker="^",
    linestyle="--",
    color="#2ca02c",
    linewidth=2,
    markersize=8,
    markerfacecolor="#2ca02c",
    label=label_model_B,
)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values, fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit

# Set the title and labels
ax.set_title(title_1, fontsize=20)
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Remove tick lines outside the plotting area
ax.tick_params(
    axis="both", which="both", length=0, color="#d2d2d2"
)  # Remove tick marks and set their color

# Add a legend with a title
ax.legend(
    title=title_2,
    loc="lower right",
    fontsize=12,
    title_fontsize=12,
    edgecolor="#e0e0e0",
)

# Change the plot background color
ax.set_facecolor("#f0f0f0")

# Show grid with lighter color
ax.grid(True, color="#cccccc", linewidth=1.2)

# Change the axis colors
ax = plt.gca()
ax.spines["bottom"].set_color("#b0b0b0")
ax.spines["top"].set_color("#b0b0b0")  # Optional: hide or set color
ax.spines["left"].set_color("#b0b0b0")
ax.spines["right"].set_color("#b0b0b0")  # Optional: hide or set color

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_166.pdf", bbox_inches="tight")
