
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for religious trends over years
years = [2000, 2005, 2010, 2015, 2020]
group_a = [0.45, 0.50, 0.55, 0.60, 0.64]  # Group A proportion
group_b = [0.35, 0.40, 0.43, 0.44, 0.45]  # Group B proportion
group_c = [0.15, 0.20, 0.25, 0.28, 0.30]  # Group C proportion
group_d = [0.05, 0.10, 0.15, 0.18, 0.20]  # Group D proportion

# Axes Limits and Labels
xlabel_value = "Year"
xlim_values = [1995, 2025]
xticks_values = np.arange(2000, 2021, 5)

ylabel_value = "Proportion of Followers"
ylim_values = [0.00, 0.70]
yticks_values = np.arange(0.0, 0.71, 0.10)

# Labels
label_1 = "Group A"
label_2 = "Group B"
label_3 = "Group C"
label_4 = "Group D"
title="Religious Group Trends Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
plt.figure(figsize=(8, 5))  # Adjusted to match the original image's dimensions
plt.plot(years, group_a, marker="o", linestyle="-", color="#1f77b4", label=label_1)
plt.plot(years, group_b, marker="s", linestyle="--", color="#2ca02c", label=label_2)
plt.plot(years, group_c, marker="^", linestyle=":", color="#ff7f0e", label=label_3)
plt.plot(years, group_d, marker="d", linestyle="-.", color="#d62728", label=label_4)

# Set x,y-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=10)
plt.xlim(xlim_values)  
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  

# Add vertical dotted line
plt.axvline(x=2010, color="grey", linestyle=":", linewidth=1.2)

# Add legend
plt.legend(loc="upper left", fontsize=12)

# Add labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.title(title, fontsize=14)

# Add grid for better readability
plt.grid(True, linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_168.pdf", bbox_inches="tight")
