
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D  # Importing Line2D for creating custom legend items

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data (Finance Domain)
time_periods = [1, 2, 3, 4, 5, 6, 7]
snp_500 = [100, 102, 104, 108, 110, 115, 120]
nasdaq = [100, 105, 110, 112, 115, 120, 125]
dow_jones = [100, 101, 103, 107, 109, 113, 116]
russell_2000 = [100, 99, 98, 100, 102, 105, 110]

# Axes Limits and Labels
xlabel_value = "Time Period (Months)"
ylabel_value_1 = "S&P 500 / Dow Jones"
ylabel_value_2 = "NASDAQ / Russell 2000"
ylim_values_1 = [90, 130]
ylim_values_2 = [90, 130]
yticks_values_1 = range(90, 131, 10)
yticks_values_2 = range(90, 131, 10)

# Labels
label_snp = "S&P 500"
label_nasdaq = "NASDAQ"
label_dow = "Dow Jones"
label_russell = "Russell 2000"
title_text = "Performance of Major Stock Indexes Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax1 = plt.subplots(figsize=(10, 8))

# S&P 500 and Dow Jones plots
(snp_line,) = ax1.plot(
    time_periods,
    snp_500,
    "o-",
    color="#1f77b4",
    label=label_snp,
    markersize=8,
    linewidth=2.5,
)
(dow_line,) = ax1.plot(
    time_periods,
    dow_jones,
    "s--",
    color="#ff7f0e",
    label=label_dow,
    markersize=8,
    linewidth=2.5,
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#1f77b4")
ax1.tick_params(axis="y", labelcolor="#1f77b4", direction="in", labelsize=12)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)
ax1.grid(which='major', linestyle='--', linewidth='0.5', color='gray')

# Adding values to the plot for S&P 500 and Dow Jones
for i, txt in enumerate(snp_500):
    ax1.annotate(
        f"{txt}",
        (time_periods[i], txt),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(dow_jones):
    ax1.annotate(
        f"{txt}",
        (time_periods[i], txt),
        textcoords="offset points",
        xytext=(0, -15),
        ha="center",
        fontsize=10,
    )

# NASDAQ and Russell 2000 plots with a secondary y-axis
ax2 = ax1.twinx()
(nasdaq_line,) = ax2.plot(
    time_periods,
    nasdaq,
    "^-",
    color="#2ca02c",
    label=label_nasdaq,
    markersize=8,
    linewidth=2.5,
)
(russell_line,) = ax2.plot(
    time_periods,
    russell_2000,
    "d-.",
    color="#d62728",
    label=label_russell,
    markersize=8,
    linewidth=2.5,
)
ax2.set_ylabel(ylabel_value_2, color="#2ca02c", fontsize=14)
ax2.tick_params(axis="y", labelcolor="#2ca02c", direction="in", labelsize=12)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Adding values to the plot for NASDAQ and Russell 2000
for i, txt in enumerate(nasdaq):
    ax2.annotate(
        f"{txt}",
        (time_periods[i], txt),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=10,
    )
for i, txt in enumerate(russell_2000):
    ax2.annotate(
        f"{txt}",
        (time_periods[i], txt),
        textcoords="offset points",
        xytext=(0, -15),
        ha="center",
        fontsize=10,
    )

# Creating custom legend items for line styles
snp_legend = Line2D([0], [0], color="#1f77b4", linestyle="-", linewidth=2.5, label="S&P 500")
dow_legend = Line2D([0], [0], color="#ff7f0e", linestyle="--", linewidth=2.5, label="Dow Jones")
nasdaq_legend = Line2D([0], [0], color="#2ca02c", linestyle="-", linewidth=2.5, label="NASDAQ")
russell_legend = Line2D([0], [0], color="#d62728", linestyle="-.", linewidth=2.5, label="Russell 2000")

# Adding legends
first_legend = ax1.legend(
    handles=[snp_legend, dow_legend],
    loc="upper left",
    fontsize=12,
    edgecolor="black",
)
ax1.add_artist(first_legend)  # Add the first legend manually
second_legend = ax1.legend(
    handles=[nasdaq_line, russell_line],
    loc="upper right",
    fontsize=12,
    edgecolor="black"
)  # Add the second legend

# Adding title
plt.title(title_text, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_170.pdf", bbox_inches="tight")
