
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for plotting
sunlight_intensity = np.array([100, 200, 300, 400, 500, 600])  # in µmol/m²/sec
plant_growth_rate = np.array([0.5, 1.2, 1.8, 2.4, 3.0, 3.5])  # in cm/day

# Labels and Plot Types
x_critical_intensity_1 = 250
label_critical_intensity_1 = "Critical Intensity 250 µmol/m²/sec"
x_critical_intensity_2 = 500
label_critical_intensity_2 = "Critical Intensity 500 µmol/m²/sec"
label_growth_trend = "Growth Trend"

# Axes Limits and Labels
yticks_values = np.arange(0, 4, 0.5)
ylim_values = [0, 4]
xlabel_value = "Sunlight Intensity (µmol/m²/sec)"
ylabel_value = "Plant Growth Rate (cm/day)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(6, 4))

# Add vertical lines for critical intensities
ax.axvline(
    x=x_critical_intensity_1,
    color="#FF8C00",    # Dark Orange
    linestyle="--",
    label=label_critical_intensity_1,
    linewidth=2,
)
ax.axvline(
    x=x_critical_intensity_2,
    color="#FFD700",    # Gold
    linestyle="--",
    label=label_critical_intensity_2,
    linewidth=2,
)

# Plot the growth trend line
ax.plot(
    sunlight_intensity,
    plant_growth_rate,
    label=label_growth_trend,
    color="#228B22",    # Forest Green
    marker="o",
    markersize=8,
    mec="white",
    linewidth=2,
)

# Set yticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjust y-axis limit

# Customize the plot
ax.set_xscale("linear")
ax.set_xlabel(xlabel_value, fontsize=16)
ax.set_ylabel(ylabel_value, fontsize=16)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="-", linewidth=0.5)

# Add legend
ax.legend(loc="upper left", bbox_to_anchor=(0, 1), fontsize=13)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_173.pdf", bbox_inches="tight")
