
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# Data for plotting
carbon_emission_reduction = np.array(
    [10 ** (-6), 10 ** (-5.7), 10 ** (-5.3), 10 ** (-5), 10 ** (-4.5), 10 ** (-4)]
)
renewable_energy_adoption = np.array([0.5, 1.2, 1.8, 2.0, 3.5, 5.0])

# Labels and Plot Types
x_solar_power = 10 ** (-5.2)
label_solar_power = "Solar Power"
x_wind_energy = 10 ** (-5)
label_wind_energy = "Wind Energy"
x_hydro_power = 10 ** (-4.7)
label_hydro_power = "Hydro Power"
x_geothermal = 10 ** (-4.4)
label_geothermal = "Geothermal"
label_empirical_curve = "Empirical Data"

# Axes Limits and Labels
yticks_values = np.arange(0, 6, 0.5)
ylim_values = [0, 5.5]
xlabel_value = "Carbon Emission Reduction"
ylabel_value = "Renewable Energy Adoption Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Add vertical lines
ax.axvline(
    x=x_solar_power,
    color="#66c2a5",
    linestyle="--",
    label=label_solar_power,
    linewidth=2,
)
ax.axvline(
    x=x_wind_energy,
    color="#fc8d62",
    linestyle="--",
    label=label_wind_energy,
    linewidth=2,
)
ax.axvline(
    x=x_hydro_power,
    color="#8da0cb",
    linestyle="--",
    label=label_hydro_power,
    linewidth=2,
)
ax.axvline(
    x=x_geothermal, 
    color="#e78ac3", 
    linestyle="--", 
    label=label_geothermal, 
    linewidth=2
)

# Plot the empirical relationship line
ax.plot(
    carbon_emission_reduction,
    renewable_energy_adoption,
    label=label_empirical_curve,
    color="#a6d854",
    marker="s",
    markersize=8,
    mec="black",
    linewidth=3,
)

# Set yticks
plt.yticks(yticks_values, fontsize=10)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the plot
ax.set_xscale("log")
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Remove x-axis minor ticks
ax.tick_params(axis="x", which="minor", bottom=False)

# Add grid for major ticks only
ax.grid(True, which="major", linestyle="--", linewidth=0.7, color="gray")

# Add legend
ax.legend(loc="upper left", bbox_to_anchor=(0, 1), fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()  # Adjust layout to not cut off legend
plt.savefig("line_174.pdf", bbox_inches="tight")
