
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for politician approval ratings over time (e.g., months in office)
months_in_office = np.arange(1, 27, 1)
approval_mean = np.array(
    [
        60.0, 58.0, 55.5, 53.0, 50.0, 48.0, 47.0, 46.0, 45.0, 44.0,
        43.0, 45.0, 46.5, 48.0, 49.0, 50.0, 51.0, 52.5, 54.0, 54.5,
        55.0, 55.5, 56.0, 56.5, 57.0, 57.5
    ]
)
approval_std = np.array(
    [
        2.0, 2.1, 2.0, 1.8, 1.7, 1.6, 1.5, 1.4, 1.3, 1.2,
        1.2, 1.1, 1.1, 1.0, 1.1, 1.2, 1.3, 1.4, 1.4, 1.5,
        1.5, 1.6, 1.7, 1.7, 1.8, 1.8
    ]
)

# Axes Limits and Labels
xlabel_value = "Months in Office"
xlim_values = [0, 27]
xticks_values = np.arange(1, 27, 2)

ylabel_value = "Approval Rating (%)"
ylim_values = [40.0, 65.0]

# Title and Legend Labels
title_value = "Politician's Approval Ratings Over Time"
legend_mean_label = "Mean Approval Rating"
legend_std_label = "Standard Deviation"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean approval rating with the standard deviation as a shaded area
plt.figure(figsize=(8, 6))
plt.plot(months_in_office, approval_mean, label=legend_mean_label, color="#1f78b4", linestyle='-', linewidth=2, marker='o')
plt.fill_between(
    months_in_office,
    approval_mean - approval_std,
    approval_mean + approval_std,
    color="#a6cee3",
    alpha=0.4,
    label=legend_std_label
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes and title
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.title(title_value, fontsize=18, pad=20)

# Adding a Legend
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_179.pdf", bbox_inches="tight")

