
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for a sports domain (e.g., Average scores of a basketball team over games)
game_number = np.arange(1, 31, 1)
average_score_mean = np.array(
    [
        78.2, 80.1, 79.7, 81.0, 77.2, 82.3, 79.4, 83.5, 84.5, 81.5,
        82.5, 79.5, 80.5, 83.5, 81.5, 84.5, 82.5, 83.5, 84.5, 85.5,
        86.5, 87.5, 88.5, 89.5, 90.5, 91.5, 92.5, 93.5, 94.5, 95.5
    ]
)
average_score_std = np.array(
    [
        2.0, 1.9, 1.8, 1.7, 1.6, 1.5, 1.4, 1.3, 1.3, 1.3,
        1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3,
        1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3, 1.3
    ]
)

# Axes Limits and Labels
xlabel_value = "Game Number"
xlim_values = [0.5, 30.5]
xticks_values = np.arange(1, 31, 3)

ylabel_value = "Average Score"
ylim_values = [75.0, 100.0]

# Chart Titles and Legend Labels
title = "Average Scores of Basketball Team Over Games"
legend_label = "Average Score ± Std Dev"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the mean accuracy with the standard deviation as a shaded area
plt.figure(figsize=(8, 6))
plt.plot(game_number, average_score_mean, color="#ff6347", linestyle='-', linewidth=2, marker='o', markersize=6, label=legend_label)
plt.fill_between(
    game_number,
    average_score_mean - average_score_std,
    average_score_mean + average_score_std,
    color="#ff6347",
    alpha=0.2,
)

# Set x-axis to only display specific ticks and extend y-axis to leave space at top
plt.xticks(xticks_values, fontsize=12)
plt.yticks(fontsize=12)
plt.xlim(xlim_values)  # Adjusted x-axis limit
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Labeling the axes
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

# Adding title and legend
plt.title(title, fontsize=18)
plt.legend(fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("line_180.pdf", bbox_inches="tight")
