
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
versions = ["v1", "v2", "v3", "v4", "v5"]
device_A = [0.55, 0.65, 0.70, 0.75, 0.78]
device_B = [0.50, 0.60, 0.65, 0.68, 0.72]
device_C = [0.40, 0.50, 0.55, 0.60, 0.68]
device_D = [0.30, 0.40, 0.60, 0.65, 0.70]
device_E = [0.20, 0.35, 0.45, 0.50, 0.55]

# Axes Limits and Labels
xlabel_value = "Versions"
ylabel_value = "Performance Score"
ylim_values = [0.0, 0.85]
yticks_values = np.arange(0.0, 0.81, 0.2)

# Labels
label_device_A = "Device A"
label_device_B = "Device B"
label_device_C = "Device C"
label_device_D = "Device D"
label_device_E = "Device E"

title="Technological Device Performance Over Versions"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 4))
plt.plot(versions, device_A, "o-", color="#1f77b4", linewidth=2, markersize=8, label=label_device_A)
plt.plot(versions, device_B, "v-", color="#ff7f0e", linewidth=2, markersize=8, label=label_device_B)
plt.plot(versions, device_C, "s-", color="#2ca02c", linewidth=2, markersize=8, label=label_device_C)
plt.plot(versions, device_D, "P-", color="#d62728", linewidth=2, markersize=8, label=label_device_D)
plt.plot(versions, device_E, "D-", color="#9467bd", linewidth=2, markersize=8, label=label_device_E)

plt.yticks(yticks_values, fontsize=14)
plt.ylim(ylim_values)

# x-axis labels
ax = plt.gca()
ax.set_xticks(np.arange(len(versions)))  # Positional indexing for equidistant spacing
ax.set_xticklabels(versions, fontsize=14)  # Labeling x-ticks as per versions

plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)

plt.legend(loc="lower right", ncol=1, fontsize=12)

# Title and layout adjustments
plt.title(title, fontsize=18)
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
plt.savefig("line_183.pdf", bbox_inches="tight")
