
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
weeks = ["Week 1", "Week 2", "Week 3", "Week 4"]  # Treat weeks as strings to make them categorical
group_a = [3000, 4500, 5000, 7000]
group_b = [3500, 4000, 3000, 6500]
group_c = [2000, 2500, 3200, 4300]
group_d = [4500, 6000, 7000, 8000]
group_e = [1500, 1800, 2100, 2500]
group_f = [5000, 5500, 6000, 8500]

# Axes Limits and Labels
xlabel_value = "Weeks"

ylabel_value = "Average Step Count"
ylim_values = [0, 9000]
yticks_values = np.arange(0, 9001, 2000)

# Labels
label_group_a = "Group A"
label_group_b = "Group B"
label_group_c = "Group C"
label_group_d = "Group D"
label_group_e = "Group E"
label_group_f = "Group F"
title='Weekly Step Count Progress'

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
plt.figure(figsize=(8, 5))
plt.plot(weeks, group_a, color='#76C1FA', linestyle='-', marker='o', linewidth=2, label=label_group_a)
plt.plot(weeks, group_b, color='#4CAF50', linestyle='--', marker='^', linewidth=2, label=label_group_b)
plt.plot(weeks, group_c, color='#FF9800', linestyle='-', marker='s', linewidth=2, label=label_group_c)
plt.plot(weeks, group_d, color='#F44336', linestyle=':', marker='d', linewidth=2, label=label_group_d)
plt.plot(weeks, group_e, color='#9C27B0', linestyle='-.', marker='x', linewidth=2, label=label_group_e)
plt.plot(weeks, group_f, color='#00BCD4', linestyle='-', marker='p', linewidth=2, label=label_group_f)

plt.yticks(yticks_values, fontsize=12)
plt.ylim(ylim_values)

# Set x-axis labels equidistantly
ax = plt.gca()
ax.set_xticks(np.arange(len(weeks)))  # Positional indexing for equidistant spacing
ax.set_xticklabels(weeks, fontsize=12)  # Labeling x-ticks as per weeks

plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=16)

plt.legend(
    loc="upper left", ncol=2, fontsize=10, columnspacing=1
)  # Adjusted legend settings

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_184.pdf", bbox_inches="tight")
