
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for each subplot
years = [2016, 2017, 2018, 2019, 2020]
ratings_movies = [7.5, 7.8, 7.9, 8.1, 8.2]
ratings_music = [8.0, 8.2, 7.8, 8.5, 8.7]
ratings_games = [6.8, 7.1, 7.4, 7.6, 7.9]
ratings_tv = [8.2, 8.5, 8.7, 8.9, 9.0]

ratings_movies_2 = [7.3, 7.4, 7.6, 7.7, 7.8]
ratings_music_2 = [8.1, 8.3, 8.1, 8.6, 8.8]
ratings_games_2 = [6.9, 7.0, 7.2, 7.4, 7.7]
ratings_tv_2 = [8.1, 8.6, 8.8, 9.0, 9.1]

ratings_movies_3 = [7.1, 7.3, 7.5, 7.6, 7.7]
ratings_music_3 = [7.8, 7.9, 8.0, 8.3, 8.5]
ratings_games_3 = [6.5, 6.8, 7.0, 7.2, 7.5]
ratings_tv_3 = [8.0, 8.4, 8.6, 8.8, 8.9]

ratings_movies_4 = [7.4, 7.5, 7.7, 7.8, 8.0]
ratings_music_4 = [7.9, 8.0, 8.2, 8.5, 8.6]
ratings_games_4 = [6.6, 6.7, 6.9, 7.1, 7.4]
ratings_tv_4 = [8.3, 8.7, 8.9, 9.0, 9.2]

# Axes Limits and Labels
xlim_values = [2015, 2021]
xticks_values = years

ylabel_value = "Rating"
ylim_values_1 = [6.5, 9.5]
yticks_values_1 = np.arange(6.5, 9.5, 0.5)
ylim_values_2 = [5.8, 10.2]
yticks_values_2 = np.arange(5.8, 10.2, 0.5)

# Labels
label_1 = "Movies"
label_2 = "Music"
label_3 = "Video Games"
label_4 = "TV Shows"

# Titles
title_1 = "Entertainment Ratings Over Time"
title_2 = "Comparison of Ratings Across Domains"

# Plot data on each subplot
categories = ["2016-2020", "2015-2020"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(1, 4, figsize=(18, 5))

# Plot data on each subplot
colors = ["#2a9d8f", "#e76f51", "#264653", "#f4a261"]
markers = ["o", "^", "s", "*"]

# Movies
axs[0].plot(years, ratings_movies, markers[0]+"--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[0].plot(years, ratings_music, markers[1]+"--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[0].plot(years, ratings_games, markers[2]+"--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[0].plot(years, ratings_tv, markers[3]+"--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[0].set_xticks(xticks_values)
axs[0].set_title(categories[0], fontsize=14)
axs[0].set_ylabel(ylabel_value, fontsize=14)
axs[0].set_yticks(yticks_values_1)
axs[0].set_ylim(ylim_values_1)

# Music
axs[1].plot(years, ratings_movies_2, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[1].plot(years, ratings_music_2, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[1].plot(years, ratings_games_2, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[1].plot(years, ratings_tv_2, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[1].set_xticks(xticks_values)
axs[1].set_title(categories[1], fontsize=14)
axs[1].set_ylabel(ylabel_value, fontsize=14)
axs[1].set_yticks(yticks_values_2)
axs[1].set_ylim(ylim_values_2)


# Video Games
axs[2].plot(years, ratings_movies_3, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[2].plot(years, ratings_music_3, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[2].plot(years, ratings_games_3, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[2].plot(years, ratings_tv_3, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[2].set_xticks(xticks_values)
axs[2].set_title("Video Games", fontsize=14)
axs[2].set_ylabel(ylabel_value, fontsize=14)
axs[2].set_yticks(yticks_values_1)
axs[2].set_ylim(ylim_values_1)

# TV Shows
axs[3].plot(years, ratings_movies_4, markers[0] + "--", label=label_1, color=colors[0], markersize=10, linewidth=2)
axs[3].plot(years, ratings_music_4, markers[1] + "--", label=label_2, color=colors[1], markersize=10, linewidth=2)
axs[3].plot(years, ratings_games_4, markers[2] + "--", label=label_3, color=colors[2], markersize=10, linewidth=2)
axs[3].plot(years, ratings_tv_4, markers[3] + "--", label=label_4, color=colors[3], markersize=10, linewidth=2)
axs[3].set_xticks(xticks_values)
axs[3].set_title("TV Shows", fontsize=14)
axs[3].set_ylabel(ylabel_value, fontsize=14)
axs[3].set_yticks(yticks_values_2)
axs[3].set_ylim(ylim_values_2)


plt.legend(loc="center", bbox_to_anchor=(-1.6, -0.2), ncol=4, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and show plot
plt.tight_layout()
plt.savefig("line_186.pdf", bbox_inches="tight")
