
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
# New generated data
import numpy as np

np.random.seed(1)
quarters = np.array(['Q1', 'Q2', 'Q3', 'Q4'])
product_a = np.random.normal(loc=25, scale=5, size=4).clip(10, 40)
product_b = np.random.normal(loc=30, scale=7, size=4).clip(15, 50)
product_c = np.random.normal(loc=20, scale=5, size=4).clip(5, 35)
product_d = np.random.normal(loc=35, scale=5, size=4).clip(20, 50)

# Labels and Plot Types
label_product_a = "Product A"
label_product_b = "Product B"
label_product_c = "Product C"
label_product_d = "Product D"

# Axes Limits and Labels
yticks_values = np.arange(0, 60, 10)
ylim_values = [0, 55]
xlabel_value = "Quarters"
ylabel_value = "Revenue Growth (%)"
chart_title = "Quarterly Revenue Growth for Product Lines"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting with error bars (second-level element)
plt.figure(figsize=(10, 6))  # Increased figure size for clarity
plt.plot(quarters, product_a, "-o", label=label_product_a, color="#2b83ba")
plt.fill_between(quarters, product_a - 5, product_a + 5, color="#2b83ba", alpha=0.2)
plt.plot(quarters, product_b, "-s", label=label_product_b, color="#abdda4")
plt.fill_between(quarters, product_b - 7, product_b + 7, color="#abdda4", alpha=0.2)
plt.plot(quarters, product_c, "--^", label=label_product_c, color="#fdae61")
plt.fill_between(quarters, product_c - 5, product_c + 5, color="#fdae61", alpha=0.2)
plt.plot(quarters, product_d, "-.x", label=label_product_d, color="#d73027")
plt.fill_between(quarters, product_d - 5, product_d + 5, color="#d73027", alpha=0.2)

# Customizing axes and labels (third-level elements)
plt.yticks(yticks_values, fontsize=12)
plt.xticks(fontsize=12)
plt.ylim(ylim_values)
plt.grid(True)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="upper left", frameon=True, shadow=True, fontsize=10)

# Customizing the background (third-level element)
plt.gca().set_facecolor("#f4f4f5")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(chart_title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_189.pdf", bbox_inches="tight")
