
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate new data
np.random.seed(0)
doses = np.linspace(10, 50, 5)
control_group = np.random.normal(loc=50, scale=5, size=5).clip(30, 70)
low_dose = np.random.normal(loc=60, scale=8, size=5).clip(35, 75)
medium_dose = np.random.normal(loc=70, scale=10, size=5).clip(40, 85)
high_dose = np.random.normal(loc=85, scale=5, size=5).clip(50, 95)

# Labels and Plot Types
label_control_group = "Control Group"
label_low_dose = "Low Dose"
label_medium_dose = "Medium Dose"
label_high_dose = "High Dose"

# Axes Limits and Labels
yticks_values = np.arange(30, 101, 10)
ylim_values = [30, 100]
xlabel_value = "Drug Dose (mg)"
ylabel_value = "Recovery Rate (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting with error bars
plt.figure(figsize=(10, 7))  # Increased figure size for better readability
plt.plot(doses, control_group, "-o", label=label_control_group, color="#4c72b0")
plt.fill_between(doses, control_group - 5, control_group + 5, color="#4c72b0", alpha=0.2)
plt.plot(doses, low_dose, "-^", label=label_low_dose, color="#55a868")
plt.fill_between(doses, low_dose - 8, low_dose + 8, color="#55a868", alpha=0.2)
plt.plot(doses, medium_dose, "-s", label=label_medium_dose, color="#c44e52")
plt.fill_between(doses, medium_dose - 10, medium_dose + 10, color="#c44e52", alpha=0.2)
plt.plot(doses, high_dose, "-d", label=label_high_dose, color="#8172b2")
plt.fill_between(doses, high_dose - 5, high_dose + 5, color="#8172b2", alpha=0.2)

# Customizing axes and labels
plt.yticks(yticks_values, fontsize=12)
plt.xticks(fontsize=12)
plt.ylim(ylim_values)
plt.grid(True, linestyle='--', linewidth=0.5)

# Relocating the legend to ensure no overlap with data lines
plt.legend(loc="lower right", frameon=True, shadow=True, fontsize=10)

# Customizing the background
plt.gca().set_facecolor("#eaeaf2")
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)

# Labels
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_190.pdf", bbox_inches="tight")
