
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data related to psychology domain
np.random.seed(0)
sessions = np.array([1, 2, 3, 4, 5])
therapy_1_values = np.array([2.1, 2.5, 3.2, 3.8, 4.1])
therapy_2_values = np.array([1.0, 1.8, 2.4, 2.9, 3.6])
therapy_3_values = np.array([1.5, 1.7, 2.5, 2.8, 3.2])
trend_values = np.poly1d(np.polyfit(sessions, therapy_2_values, 3))(sessions)

# Axes Limits and Labels
xlabel_value = "Therapy Sessions"
ylabel_value_1 = "Effectiveness (Scale 1-5)"
ylabel_value_2 = "Trend"
yticks_values_1 = np.arange(1, 5.1, 1)
yticks_values_2 = np.arange(min(trend_values), max(trend_values) + 0.1, 0.5)

# Labels
label_1 = "Therapy Technique 1"
label_2 = "Therapy Technique 2"
label_3 = "Therapy Technique 3"
label_4 = "Polynomial Trend (from Technique 2)"

suptitle="Effectiveness of Different Therapy Techniques Over Sessions"
title =["Comparison of Techniques","Polynomial Trend Analysis"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# First subplot
ax1.plot(sessions, therapy_1_values, "o-", color="#1f77b4", label=label_1, linewidth=2)
ax1.plot(sessions, therapy_2_values, "s--", color="#2ca02c", label=label_2, linewidth=2)
ax1.plot(sessions, therapy_3_values, "^:", color="#d62728", label=label_3, linewidth=2)
ax1.set_xlabel(xlabel_value, fontsize=12)
ax1.set_ylabel(ylabel_value_1, fontsize=12)
ax1.set_xticks(sessions)
ax1.set_yticks(yticks_values_1)
ax1.legend(loc="upper left", fontsize=10)
ax1.grid(True)

# Second subplot
ax2.plot(sessions, therapy_3_values, "d-.", color="#9467bd", label=label_3, linewidth=2)
ax2.plot(sessions, trend_values, "*-m", label=label_4, linewidth=2)
ax2.set_xlabel(xlabel_value, fontsize=12)
ax2.set_ylabel(ylabel_value_2, fontsize=12)
ax2.set_xticks(sessions)
ax2.set_yticks(yticks_values_2)
ax2.legend(loc="upper right", fontsize=10)
ax2.grid(True)

# Annotations and styling
for ax in (ax1, ax2):
    ax.spines["left"].set_position(("outward", 10))
    ax.spines["bottom"].set_position(("outward", 10))
    ax.spines["right"].set_color("none")
    ax.spines["top"].set_color("none")
for x, y in zip(sessions, therapy_1_values):
    ax1.annotate(
        f"{y:.1f}", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )
for x, y in zip(sessions, trend_values):
    ax2.annotate(
        f"{y:.1f}", xy=(x, y), textcoords="offset points", xytext=(0, 10), ha="center"
    )

# Add titles
fig.suptitle(suptitle, fontsize=14)
ax1.set_title(title[0], fontsize=12)
ax2.set_title(title[1], fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_196.pdf", bbox_inches="tight")
