
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Simulated data for company performance
years = np.array(["2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"])
revenue = np.array([120, 150, 170, 200, 230, 250, 270, 300])
revenue_err = np.array([5, 10, 7, 10, 10, 15, 10, 10])
profit = np.array([30, 50, 60, 80, 100, 110, 120, 140])
profit_err = np.array([3, 5, 4, 6, 7, 8, 6, 7])
expenses = np.array([70, 80, 85, 90, 100, 110, 130, 145])
expenses_err = np.array([4, 5, 6, 5, 6, 7, 8, 7])

# Axes Limits and Labels
ylabel_value = "Amount (in millions)"
ylim_values = [0, 350]
yticks_values = np.arange(0, 351, 50)

# Labels
label_1 = "Revenue"
label_2 = "Profit"
label_3 = "Expenses"

# Titles
title_1 = "Company Revenue and Profit"
title_2 = "Company Expenses"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a subplot layout of 1x2
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 5), sharey=True)

# First subplot for Revenue and Profit
ax1.errorbar(
    years,
    revenue,
    yerr=revenue_err,
    fmt="o-",
    label=label_1,
    color="#228B22",  # Dark Green
    capsize=5,
)
ax1.errorbar(
    years,
    profit,
    yerr=profit_err,
    fmt="^-",
    label=label_2,
    color="#FFD700",  # Gold
    capsize=5,
)
ax1.set_title(title_1)
ax1.set_xticks(years)
ax1.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax1.set_yticks(yticks_values)
ax1.set_ylim(ylim_values)
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="upper left", fontsize=12)

# Second subplot for Expenses
ax2.errorbar(
    years,
    expenses,
    yerr=expenses_err,
    fmt="s--",
    label=label_3,
    color="#8B0000",  # Dark Red
    capsize=5,
)
ax2.set_title(title_2)
ax2.set_xticks(years)
ax2.set_xticklabels(years, rotation=45, ha="right", fontsize=12)
ax2.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.5)
ax2.legend(loc="upper left", fontsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout
plt.tight_layout()
plt.savefig("line_197.pdf", bbox_inches="tight")
