
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate distinct data sets for each subplot
N = np.array([1, 2, 3, 4, 5, 6])
datasets = {
    "Temperature": np.array([15, 16.2, 20, 23, 21, 19]) + np.random.uniform(low=-0.5, high=0.5, size=len(N)),
    "CO2 Levels": np.array([400, 410, 420, 450, 470, 480]),
    "Pollution Index": np.array([55, 60, 72, 85, 95, 100]),
    "Green Cover": np.array([30, 28, 25, 23, 20, 18]),  # New dataset
}

# Assign each dataset to a subplot
plot_order = ["Temperature", "CO2 Levels", "Pollution Index", "Green Cover"]

# Axes Limits and Labels
xlabel_value = "Years"

ylabel_value = "Environmental Parameters"
ylim_values = [0, 600]

# Text
text = "Trend Observation"
title = "Environmental Study"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size and define colors, markers, and linestyles
fig, axs = plt.subplots(2, 2, figsize=(12, 8))  # Use a 2x2 subplot grid
colors = ["forestgreen", "royalblue", "darkorange", "chocolate"]
markers = ["o", "s", "^", "d"]
linestyles = ["-", "--", ":", "-."]

# Plot data in each subplot
for i, (ax, key) in enumerate(zip(axs.flat, plot_order)):
    for j, data_key in enumerate(plot_order):
        if key == data_key:
            ax.plot(
                N,
                datasets[data_key],
                linestyle=linestyles[j],
                marker=markers[j],
                color=colors[j],
                label=data_key,
                markersize=8,
            )
        else:
            ax.plot(
                N,
                datasets[data_key],
                linestyle=linestyles[j],
                marker=markers[j],
                color=colors[j],
                label=data_key,
                markersize=8,
                alpha=0.8,
            )  # Faded other lines

    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.set_ylim(ylim_values)  # Ensure y-axis ranges don't clip data
    ax.set_title(f"{title} {i+1}")
    ax.legend()

    # Annotations to explain features, only on primary dataset for clarity
    if i == 0 or i == 3:
        ax.annotate(
            text,
            xy=(N[-2], datasets[key][-2]),
            xytext=(N[-4], datasets[key][-2] / 1.5+100),
            arrowprops=dict(arrowstyle="->", color="navy"),
            textcoords="data",
        )
    else:
        ax.annotate(
            text,
            xy=(N[-2], datasets[key][-2]),
            xytext=(N[-4], datasets[key][-2] * 1.1),
            arrowprops=dict(arrowstyle="->", color="navy"),
            textcoords="data",
        )

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent overlap and ensure clarity
plt.tight_layout()
plt.savefig("line_204.pdf", bbox_inches="tight")
