
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New data for plotting, representing philosophical trends

centuries = list(range(5, 25))
socratic_method_influence = np.sin(np.linspace(0, 3 * np.pi, 20)) + np.random.normal(scale=0.1, size=20)
existentialism_influence = np.cos(np.linspace(0, 3 * np.pi, 20)) + np.random.normal(scale=0.1, size=20)

# Extracted variables
line_label1 = "Socratic Method Influence"
line_label2 = "Existentialism Influence"
xlim_values = (5, 24)
ylim_values = (-1.5, 1.5)
xlabel_value = "Centuries"
ylabel_value = "Influence Level"
yticks_values = [-1.5, -1.0, -0.5, 0, 0.5, 1, 1.5]
title1 = "Influence of the Socratic Method Over Time"
title2 = "Influence of Existentialism Over Time"
legend_location = "lower center"
legend_bbox_to_anchor = (0.5, -0.2)
legend_frameon = False

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(
    2, 1, figsize=(8, 12)  # Increased size for clarity and aesthetics
)  # Use a 2x1 subplot grid for vertical layout

# Define new colors and markers for a fresh look
colors = ["forestgreen", "indigo"]
linestyles = ["-", ":"]
labels = [line_label1, line_label2]

# First subplot
axs[0].plot(
    centuries, socratic_method_influence, color=colors[0], linestyle=linestyles[0], label=labels[0]
)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value)
axs[0].set_xlim(xlim_values)
axs[0].set_ylim(ylim_values)
axs[0].set_yticks(yticks_values)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].tick_params(axis="both", which="both", length=0)

# Second subplot
axs[1].plot(
    centuries,
    existentialism_influence,
    color=colors[1],
    linestyle=linestyles[1],
    label=labels[1],
)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value)
axs[1].set_ylim(ylim_values)
axs[1].set_xlim(xlim_values)
axs[1].set_yticks(yticks_values)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Enhance overall layout and visuals
plt.tight_layout()
plt.savefig("line_208.pdf", bbox_inches="tight")
