
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for a complex scenario
months = np.arange(1, 13, 1)  # Months of the year
stress_levels = 50 + 10 * np.sin(0.5 * np.pi * (months - 3) / 12) + np.random.normal(0, 5, len(months))  # Simulated stress levels
happiness_index = 70 - 15 * np.sin(0.5 * np.pi * (months - 3) / 12) + np.random.normal(0, 5, len(months))  # Simulated happiness index

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value_1 = "Stress Levels"
ylabel_value_2 = "Happiness Index"

# Labels
label_1 = "Monthly Stress Levels"
label_2 = "Monthly Happiness Index"

# Titles
title = "Stress Levels and Happiness Index Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot stress levels data with primary axis
color = "#6a0dad"  # Purple color for stress levels
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(months, stress_levels, label=label_1, color=color, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_xticks(months)
ax1.set_title(title)

# Create a second y-axis for happiness index
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color = "#FFD700"  # Gold color for happiness index
ax2.set_ylabel(ylabel_value_2, color=color)  # We already handled the x-label with ax1
ax2.plot(months, happiness_index, label=label_2, color=color, marker="s", linestyle="--", linewidth=2)
ax2.tick_params(axis="y", labelcolor=color)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper right", frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_212.pdf", bbox_inches="tight")

