
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for a business scenario
quarters = np.array([1, 2, 3, 4])  # Quarters of the year
revenue = np.random.normal(200000, 50000, len(quarters))  # Simulate quarterly revenue
satisfaction = (
    70 + 10 * np.sin(0.5 * np.pi * quarters)
)  # Simulate customer satisfaction scores

# Axes Limits and Labels
xlabel_value = "Quarter"

ylabel_value_1 = "Revenue ($)"
ylabel_value_2 = "Customer Satisfaction (Score)"

# Labels
label_1 = "Quarterly Revenue"
label_2 = "Customer Satisfaction"

# Titles
title = "Revenue and Customer Satisfaction Correlation Over a Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the main figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot revenue data with primary axis
color = "#1f77b4"  # Custom color for revenue
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(quarters, revenue, label=label_1, color=color, marker="o", linestyle="-", linewidth=2)
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_xticks(quarters)
ax1.set_title(title, fontsize=14, fontweight='bold')

# Create a second y-axis for customer satisfaction
ax2 = ax1.twinx()  # Instantiate a second axes that shares the same x-axis
color = "#ff7f0e"  # Custom color for satisfaction score
ax2.set_ylabel(ylabel_value_2, color=color)  # We already handled the x-label with ax1
ax2.plot(
    quarters,
    satisfaction,
    label=label_2,
    color=color,
    marker="s",
    linestyle="--",
    linewidth=2,
)
ax2.tick_params(axis="y", labelcolor=color)

# Add grid lines for better readability
ax1.grid(True)

# Add legends to the plot
lines, labels = ax1.get_legend_handles_labels()
lines2, labels2 = ax2.get_legend_handles_labels()
ax1.legend(lines + lines2, labels + labels2, loc="upper left", frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_213.pdf", bbox_inches="tight")
