
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation
days = np.arange(0, 11, 1)
temperature = np.random.uniform(15, 30, len(days))
humidity = np.random.uniform(40, 60, len(days))
wind_speed = np.random.uniform(5, 20, len(days))

# Extracted variables
temp_label = "Temperature"
humidity_label = "Humidity"
wind_label = "Wind Speed"

xlim_values = (0, 10)
ylim_values_temp = (10, 35)
ylim_values_humidity = (30, 70)
ylim_values_wind = (0, 25)

yticks_temp = np.arange(10, 36, 5)
yticks_humidity = np.arange(30, 71, 10)
yticks_wind = np.arange(0, 26, 5)

xlabel_value = "Day"
ylabel_value = "Measurements"

title_temp = "Daily Temperature"
title_humidity = "Daily Humidity"
title_wind = "Daily Wind Speed"

legend_location = "upper right"
legend_bbox_to_anchor = (1, 1.15)
legend_frameon = False

grid_linestyle = ":"
grid_alpha = 0.8

tick_params_color = "black"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(8, 12))

# First subplot: Temperature
axs[0].plot(
    days,
    temperature,
    label=temp_label,
    color="#FF7F0E",  # Orange
    linestyle="--",
    marker="^",
)
axs[0].set_title(title_temp, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_temp)
axs[0].set_yticks(yticks_temp)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Humidity
axs[1].plot(
    days,
    humidity,
    label=humidity_label,
    color="#1F77B4",  # Blue
    linestyle="-.",
    marker="D",
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_humidity)
axs[1].set_yticks(yticks_humidity)
axs[1].set_title(title_humidity, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Wind Speed
axs[2].plot(
    days,
    wind_speed,
    label=wind_label,
    color="#2CA02C",  # Green
    linestyle="-",
    marker="o",
)
axs[2].set_title(title_wind, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_wind)
axs[2].set_yticks(yticks_wind)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_215.pdf", bbox_inches="tight")
