
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data preparation

times = [0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0]
user_growth = [1.2, 1.5, 1.9, 2.5, 3.1, 3.9, 4.7, 5.5, 6.4, 7.3, 8.2]  # exponential user growth 
content_decay = [5.0, 4.5, 3.8, 3.0, 2.5, 2.0, 1.5, 1.2, 1.0, 0.8, 0.6]  # decay in content engagement 
spikes_in_engagement = [0.5, 1.5, 0.3, 2.0, 1.0, 3.0, 1.2, 2.5, 0.8, 3.5, 1.0]  # periodic spikes in engagement

# Extracted variables
user_growth_label = "User Growth"
content_decay_label = "Content Decay"
spikes_label = "Spikes in Engagement"

xlim_values = (0, 10)
ylim_values_user_growth = (0, 9)
ylim_values_content_decay = (0, 6)
ylim_values_spikes = (0, 4)

yticks_user_growth = [0, 2, 4, 6, 8]
yticks_content_decay = [0, 2, 4, 6]
yticks_spikes = [0, 1, 2, 3, 4]

xlabel_value = "Time (Months)"
ylabel_value = "Value"

title_user_growth = "User Growth Over Time"
title_content_decay = "Content Decay Over Time"
title_spikes = "Spikes in Engagement Over Time"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
legend_location = "upper center"
legend_bbox_to_anchor = (0.5, 1.15)
legend_frameon = False

grid_linestyle = "--"
grid_alpha = 0.5

tick_params_color = "gray"

# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(6, 9))

# First subplot: User Growth
axs[0].plot(
    times,
    user_growth,
    label=user_growth_label,
    color="#1f77b4",
    clip_on=False,
    zorder=10,
    linestyle="--",
    marker="o",
    linewidth=2,
    markersize=6
)
axs[0].set_title(title_user_growth, y=1.1)
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_user_growth)
axs[0].set_yticks(yticks_user_growth)
axs[0].set_ylabel(ylabel_value)
axs[0].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[0].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[0].tick_params(axis="both", which="both", color=tick_params_color)

# Second subplot: Content Decay
axs[1].plot(
    times,
    content_decay,
    label=content_decay_label,
    color="#ff7f0e",
    clip_on=False,
    zorder=10,
    linestyle="-.",
    marker="x",
    linewidth=2,
    markersize=6
)
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_content_decay)
axs[1].set_yticks(yticks_content_decay)
axs[1].set_title(title_content_decay, y=1.1)
axs[1].set_ylabel(ylabel_value)
axs[1].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[1].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[1].tick_params(axis="both", which="both", color=tick_params_color)

# Third subplot: Spikes in Engagement
axs[2].plot(
    times,
    spikes_in_engagement,
    label=spikes_label,
    clip_on=False,
    zorder=10,
    color="#2ca02c",
    linestyle=":",
    marker="s",
    linewidth=2,
    markersize=6
)
axs[2].set_title(title_spikes, y=1.1)
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_spikes)
axs[2].set_yticks(yticks_spikes)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)
axs[2].legend(
    loc=legend_location, bbox_to_anchor=legend_bbox_to_anchor, frameon=legend_frameon
)
axs[2].grid(True, linestyle=grid_linestyle, alpha=grid_alpha)
axs[2].tick_params(
    axis="both",
    which="both",
    color=tick_params_color,
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_217.pdf", bbox_inches="tight")
