
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set seed for reproducibility
np.random.seed(42)

# Generate new environmental data (e.g., temperature variations)
x = np.linspace(0, 20, 20)
original_data = 10 + 5 * np.sin(x) + np.random.normal(0, 0.5, 20)  # Temperature data with noise
smoothed_data = np.convolve(original_data, np.ones(5) / 5, mode="valid")  # Smoothed data
difference_data = np.diff(original_data)  # Change in temperature
cumulative_data = np.cumsum(original_data)  # Cumulative sum of temperature

# Axes Limits and Labels
xlabel_value = "Time (Days)"
ylabel_value_1 = "Temperature (°C)"
ylabel_value_2 = "Change in Temperature (°C)"
ylabel_value_3 = "Cumulative Temperature (°C)"

# Labels
label_1 = "Smoothed Temperature"
label_2 = "Temperature Change"
label_3 = "Cumulative Temperature"

# Titles
title_1 = "Smoothed Temperature Over Time"
title_2 = "Daily Temperature Change"
title_3 = "Cumulative Temperature Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(7, 15))

# First subplot: Smoothed Data
axs[0].plot(x[2:-2], smoothed_data, label=label_1, color="#2A9D8F", linestyle="--", marker="o", linewidth=2, markersize=6)
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle="--", alpha=0.7)

# Second subplot: Difference Data
axs[1].plot(x[1:], difference_data, label=label_2, color="#E76F51", linestyle=":", marker="x", linewidth=2, markersize=8)
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle="--", alpha=0.7)

# Third subplot: Cumulative Sum
axs[2].plot(x, cumulative_data, label=label_3, color="#264653", linestyle="-", marker="s", linewidth=2, markersize=6)
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_219.pdf", bbox_inches="tight")
