
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generating new data for transportation domain
time = np.linspace(0, 20, 20)

# Simulated data
vehicle_speed = np.sin(time) * 20 + 50 + np.random.normal(0, 5, 20)  # Vehicle speed with noise
smoothed_vehicle_speed = np.convolve(vehicle_speed, np.ones(5) / 5, mode="valid")  # Smoothed data
traffic_flow = np.diff(vehicle_speed)  # Traffic flow data as difference
distance_traveled = np.cumsum(vehicle_speed)  # Cumulative sum data representing distance

# Axes Limits and Labels
xlabel_value = "Time (hours)"
ylabel_value_1 = "Speed (km/h)"
ylabel_value_2 = "Change in Speed (km/h)"
ylabel_value_3 = "Distance (km)"

# Labels
label_1 = "Smoothed Speed"
label_2 = "Traffic Flow"
label_3 = "Total Distance"

# Titles
title_1 = "Vehicle Speed Over Time"
title_2 = "Traffic Flow Fluctuations"
title_3 = "Cumulative Distance Traveled"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 3-subplot layout
fig, axs = plt.subplots(3, 1, figsize=(5, 10))

# First subplot: Smoothed Speed
axs[0].plot(
    time[2:-2],
    smoothed_vehicle_speed,
    label=label_1,
    color="blue",
    linestyle="--",
    marker="v",
)
axs[0].set_title(title_1)
axs[0].set_ylabel(ylabel_value_1)
axs[0].legend(loc="upper right")
axs[0].grid(True, linestyle=":", alpha=0.7)

# Second subplot: Traffic Flow
axs[1].plot(
    time[1:],
    traffic_flow,
    label=label_2,
    color="red",
    linestyle="-.",
    marker="x",
)
axs[1].set_title(title_2)
axs[1].set_ylabel(ylabel_value_2)
axs[1].legend(loc="upper right")
axs[1].grid(True, linestyle=":", alpha=0.7)

# Third subplot: Cumulative Distance
axs[2].plot(time, distance_traveled, label=label_3, color="green", linestyle="-", marker="o")
axs[2].set_title(title_3)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value_3)
axs[2].legend(loc="upper right")
axs[2].grid(True, linestyle=":", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_220.pdf", bbox_inches="tight")
