
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# New datasets based on philosophical themes
t = np.linspace(0, 10, 21)  # Time points from 0 to 10

# Data series
wisdom = np.cumsum(np.random.normal(0.1, 0.05, t.size))  # Gradual increase
ethics = np.sin(t) + np.random.normal(0, 0.1, t.size)  # Fluctuations simulating moral dilemmas
existentialism = np.sign(np.sin(t)) * np.random.normal(0.8, 0.2, t.size)  # Sharp peaks and valleys
stoicism = 1 / (1 + np.exp(-0.5 * (t - 5)))  # Steady rise to an asymptote

# Labels for legend
label_wisdom = "Wisdom"
label_ethics = "Ethics"
label_existentialism = "Existentialism"
label_stoicism = "Stoicism"

# Plot configuration
xlim_values = (0, 10)
ylim_values_general = (-2, 2)

xlabel_value = "Time"
ylabel_value = "Intensity"
ylabel_value_stoic = "Level"

title_wisdom = "Accumulation of Wisdom"
title_ethics = "Ethical Fluctuations"
title_existentialism = "Existential Crises"
title_stoicism = "Stoic Stability"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, axs = plt.subplots(4, 1, figsize=(6, 12))

axs[0].plot(t, wisdom, label=label_wisdom, linestyle='-', linewidth=2, color="#2E91E5")
axs[0].set_xlim(*xlim_values)
axs[0].set_ylim(*ylim_values_general)
axs[0].set_title(title_wisdom, y=1.1)
axs[0].set_xlabel(xlabel_value)
axs[0].set_ylabel(ylabel_value)

axs[1].plot(t, ethics, label=label_ethics, linestyle='--', linewidth=2, color="#E15F99")
axs[1].set_xlim(*xlim_values)
axs[1].set_ylim(*ylim_values_general)
axs[1].set_title(title_ethics, y=1.1)
axs[1].set_xlabel(xlabel_value)
axs[1].set_ylabel(ylabel_value)

axs[2].plot(t, existentialism, label=label_existentialism, linestyle='-.', linewidth=2, color="#1CA71C")
axs[2].set_xlim(*xlim_values)
axs[2].set_ylim(*ylim_values_general)
axs[2].set_title(title_existentialism, y=1.1)
axs[2].set_xlabel(xlabel_value)
axs[2].set_ylabel(ylabel_value)

axs[3].plot(t, stoicism, label=label_stoicism, linestyle=':', linewidth=2, color="#FB0D0D")
axs[3].set_xlim(*xlim_values)
axs[3].set_ylim(0, 1.2)
axs[3].set_title(title_stoicism, y=1.1)
axs[3].set_xlabel(xlabel_value)
axs[3].set_ylabel(ylabel_value_stoic)

for ax in axs.flat:
    ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), frameon=False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("line_223.pdf", bbox_inches="tight")
