
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for energy domain
time_intervals = np.array([1, 2, 3, 4, 5])
energy_efficiency = np.array([85, 88, 87, 89, 90])
energy_efficiency_error = np.array([2, 1, 2, 1, 2])

power_consumption = np.array([400, 380, 390, 370, 360])
power_consumption_error = np.array([20, 15, 25, 20, 10])

renewable_energy_usage = np.array([60, 62, 61, 63, 64])
renewable_energy_usage_error = np.array([3, 2, 3, 2, 3])

co2_emissions = np.array([200, 190, 195, 185, 180])
co2_emissions_error = np.array([10, 12, 15, 10, 5])

# Titles
titles = [
    "(a) Energy Efficiency",
    "(b) Power Consumption",
    "(d) Renewable Energy Usage",
    "(c) CO2 Emissions"
]

# Axis labels
xlabel = "Time Interval (days)"
ylabel_efficiency = "Efficiency (%)"
ylabel_consumption = "Power (kW)"
ylabel_renewable = "Usage (%)"
ylabel_co2 = "Emissions (tons)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x2 subplots
fig, axs = plt.subplots(2, 2, figsize=(10, 8))

# Flatten the axis array for easy iteration
axs = axs.flatten()

# Setting data for each subplot
data = [
    (time_intervals, energy_efficiency, energy_efficiency_error, ylabel_efficiency), 
    (time_intervals, power_consumption, power_consumption_error, ylabel_consumption), 
    (time_intervals, renewable_energy_usage, renewable_energy_usage_error, ylabel_renewable), 
    (time_intervals, co2_emissions, co2_emissions_error, ylabel_co2)
]

# Custom colors
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot with error bars in each subplot
for ax, (x, y, e, ylabel), title, color in zip(axs, data, titles, colors):
    ax.errorbar(x, y, yerr=e, fmt="--s", color=color, ecolor="gray", capsize=8, markersize=8, markerfacecolor="white")
    ax.set_title(title, fontsize=16)
    ax.set_xlabel(xlabel, fontsize=14)
    ax.set_ylabel(ylabel, fontsize=14)
    ax.grid(True, alpha=0.5)
    ax.set_xticks(x)
    ax.set_yticks(np.linspace(min(y) - min(e), max(y) + max(e), num=5, endpoint=True))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("line_225.pdf", bbox_inches="tight")
