
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data related to religion over various metrics
years = np.array([2000, 2005, 2010, 2015, 2020])
followers_percentage = np.random.uniform(30, 80, size=len(years))
followers_percentage_error = np.random.uniform(1, 5, size=len(years))

growth_rate = np.array([1, 2, 3, 4, 5])
growth_rate_values = np.random.uniform(0.5, 3.5, size=len(growth_rate))
growth_rate_error = np.random.uniform(0.1, 0.5, size=len(growth_rate))

average_age = np.array([25, 35, 45, 55, 65])
average_age_values = np.random.uniform(20, 50, size=len(average_age))
average_age_error = np.random.uniform(2, 8, size=len(average_age))

attendance_rate = np.array([5, 10, 15, 20, 25])
attendance_rate_values = np.random.uniform(60, 90, size=len(attendance_rate))
attendance_rate_error = np.random.uniform(2, 5, size=len(attendance_rate))

religious_activities = np.array([1, 2, 3, 4, 5])
activities_values = np.random.uniform(2, 10, size=len(religious_activities))
activities_error = np.random.uniform(0.5, 2.5, size=len(religious_activities))

satisfaction_level = np.array([10, 20, 30, 40, 50])
satisfaction_values = np.random.uniform(70, 95, size=len(satisfaction_level))
satisfaction_error = np.random.uniform(1, 5, size=len(satisfaction_level))

# Titles and labels
titles = [
    "Followers Percentage Over Years",
    "Growth Rate of Followers",
    "Average Age of Followers",
    "Attendance Rate at Religious Events",
    "Frequency of Religious Activities per Week",
    "Satisfaction Level of Followers",
]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create 2x3 subplots for a unified visual presentation
fig, axs = plt.subplots(2, 3, figsize=(15, 10))

colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b"]

data_pairs = [
    (years, followers_percentage, followers_percentage_error),
    (growth_rate, growth_rate_values, growth_rate_error),
    (average_age, average_age_values, average_age_error),
    (attendance_rate, attendance_rate_values, attendance_rate_error),
    (religious_activities, activities_values, activities_error),
    (satisfaction_level, satisfaction_values, satisfaction_error),
]

for ax, (x, y, e), title, color in zip(axs.flat, data_pairs, titles, colors):
    ax.errorbar(
        x, y, yerr=e, fmt="-o", color=color, ecolor="lightgray", capsize=5, label=title
    )
    ax.set_title(title)
    ax.set_xlabel("X Axis Label", fontsize=10)
    ax.set_ylabel("Y Axis Label", fontsize=10)
    ax.set_xticks(x)
    ax.set_ylim(min(y) - min(e) - 2, max(y) + max(e) + 2)
    ax.legend(loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to ensure no overlap and labels are clearly visible
plt.tight_layout()
plt.savefig("line_228.pdf", bbox_inches="tight")
