
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
regions = ["Coastal", "Mountainous", "Desert", "Urban"]
temperatures_winter = [5, -5, 15, 8]
temperatures_summer = [25, 20, 40, 30]
temperatures_spring = [15, 10, 25, 20]
temperatures_fall = [10, 5, 20, 15]

error = [1.5, 1.5, 1.5, 1.5]

# Axes Limits and Labels
xlabel_value = "Region Type"
ylabel_value = "Average Temperature (°C)"
ylim_values = [-10, 45]

# Titles
titles = ["Winter vs Summer", "Spring vs Fall", "Summer vs Fall"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x3 subplot layout
fig, axs = plt.subplots(1, 3, figsize=(15, 5))

# Titles and setup for subplots
data_pairs = [
    (temperatures_winter, temperatures_summer),
    (temperatures_spring, temperatures_fall),
    (temperatures_summer, temperatures_fall),
]
colors_pairs = [("#0077BB", "#CC3311"), ("#009988", "#EE7733"), ("#CC3311", "#EE7733")]
markers_pairs = [('o', 's'), ('^', 'D'), ('s', 'D')]
line_styles_pairs = [('-', '--'), ('-.', ':'), ('--', '-')]

# Plot each condition in a separate subplot
for ax, title, (data1, data2), (color1, color2), (marker1, marker2), (style1, style2) in zip(
    axs, titles, data_pairs, colors_pairs, markers_pairs, line_styles_pairs
):
    ax.errorbar(
        regions,
        data1,
        yerr=error,
        fmt=marker1+style1,
        color=color1,
        ecolor=color1,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[0]}',
        markersize=8,
        linewidth=2,
    )
    ax.errorbar(
        regions,
        data2,
        yerr=error,
        fmt=marker2+style2,
        color=color2,
        ecolor=color2,
        elinewidth=2,
        capsize=5,
        capthick=2,
        label=f'{title.split(" vs ")[1]}',
        markersize=8,
        linewidth=2,
    )
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.tick_params(
        axis="both", which="major", length=5, direction="in", top=True, right=True
    )
    ax.legend(loc="upper right", frameon=True)
    ax.set_ylim(ylim_values)
    ax.grid(True, which="major", linestyle="--", linewidth=0.5, alpha=0.5)
    ax.set_title(title)

# Super Title
plt.suptitle("Average Temperatures Across Different Regions and Seasons", fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("line_231.pdf", bbox_inches="tight")
