
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Updated data for psychology domain
sessions = ["0", "1", "2", "3", "4", "5", "6", "7"]
beginner = np.array([7, 6.5, 6, 5.5, 5, 4.5, 4, 3.5])
intermediate = np.array([6, 5.5, 5, 4.5, 4, 3.5, 3, 2.5])
advanced = np.array([5, 4.5, 4, 3.5, 3, 2.5, 2, 1.5])

# Axes Limits and Labels
xlabel_value = "Meditation Sessions"
xlim_values = [0, len(sessions) - 1]

ylabel_value = "Stress Level"
ylim_values = [0, max(beginner) + 1]

# Labels
label_Beginner = "Beginner"
label_Intermediate = "Intermediate"
label_Advanced = "Advanced"

# Titles
title = "Stress Level Reduction Across Meditation Sessions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(8, 3))
ax.plot(
    sessions,
    beginner,
    "o-",
    label=label_Beginner,
    color="#A1C9F1",  # Calming blue
    linewidth=2,
    markersize=8,
)
ax.plot(
    sessions,
    intermediate,
    "s--",
    label=label_Intermediate,
    color="#F1A1C9",  # Soothing pink
    linewidth=2,
    markersize=8,
)
ax.plot(
    sessions,
    advanced,
    "^:",
    label=label_Advanced,
    color="#A1F1C9",  # Relaxing green
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f5f5f5")  # Light grey background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper right", fontsize=12, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_233.pdf", bbox_inches="tight")

