
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Updated data
periods = ["Ancient", "Medieval", "Renaissance", "Industrial", "Modern", "Postmodern", "21st Century"]
political_events = np.array([5, 6, 8, 7, 6, 3, 4])
technological_advancements = np.array([1, 2, 4, 6, 8, 9, 10])
social_movements = np.array([0.5, 1.5, 3, 5, 6, 7.5, 8])

# Axes Limits and Labels
xlabel_value = "Historical Period"
xlim_values = [0, len(periods) - 1]

ylabel_value = "Significance Level"
ylim_values = [0, 11]

# Labels
label_Political = "Political Events"
label_Technological = "Technological Advancements"
label_Social = "Social Movements"

# Titles
title = "Significance of Events Across Historical Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 5))
ax.plot(
    periods,
    political_events,
    "d-",
    label=label_Political,
    color="#1f78b4",
    linewidth=2,
    markersize=8,
)
ax.plot(
    periods,
    technological_advancements,
    "o--",
    label=label_Technological,
    color="#33a02c",
    linewidth=2,
    markersize=8,
)
ax.plot(
    periods,
    social_movements,
    "s:",
    label=label_Social,
    color="#e31a1c",
    linewidth=2,
    markersize=8,
)

# Enhancements for visual appeal
ax.set_facecolor("#f0f0f5")  # Light grey background
ax.spines["top"].set_color("none")
ax.spines["right"].set_color("none")
ax.spines["left"].set_color("gray")
ax.spines["bottom"].set_color("gray")

# Setting axis limits and ticks dynamically based on data
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Customizing labels and grid
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)
ax.set_title(title, fontsize=16)

# Custom legend
ax.legend(loc="upper left", fontsize=12, frameon=True, shadow=True)

# Grid
ax.grid(True, linestyle="--", alpha=0.5, color="grey")

# ===================
# Part 4: Saving Output
# ===================
# Tight layout for better spacing
plt.tight_layout()
plt.savefig("line_234.pdf", bbox_inches="tight")
