
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Simulated data for philosophical discussions
discussion_levels = [1, 2, 3, 4]
agreement_rate_basic = np.array([0.45, 0.50, 0.55, 0.60])
agreement_rate_advanced = np.array([0.40, 0.48, 0.53, 0.58])
disagreement_rate_basic = np.array([0.35, 0.32, 0.30, 0.28])
disagreement_rate_advanced = np.array([0.38, 0.35, 0.33, 0.30])
reflection_rate_basic = np.array([0.25, 0.30, 0.35, 0.40])
reflection_rate_advanced = np.array([0.22, 0.28, 0.33, 0.38])
critique_rate_basic = np.array([0.20, 0.22, 0.24, 0.26])
critique_rate_advanced = np.array([0.18, 0.21, 0.23, 0.25])

# Axes Limits and Labels
xlabel_value = "Discussion Level"
ylabel_value = "Rate (%)"

# Labels
label_1 = " (Basic)"
label_2 = " (Advanced)"
label_3 = "Agreement Rate vs. Discussion Level"
label_4 = "Disagreement Rate vs. Discussion Level"
label_5 = "Reflection Rate vs. Discussion Level"
label_6 = "Critique Rate vs. Discussion Level"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the plots
colors = ["navy", "mediumpurple", "darkgreen", "teal"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, marker1, marker2, color1, color2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        linestyle='-',
        color=color1,
        label=f"{title}{label_1}",
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        linestyle='--',
        color=color2,
        label=f"{title}{label_2}",
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    discussion_levels,
    agreement_rate_basic,
    agreement_rate_advanced,
    label_3,
    "o",
    "s",
    colors[0],
    colors[1],
)
plot_data(
    axs[0, 1],
    discussion_levels,
    disagreement_rate_basic,
    disagreement_rate_advanced,
    label_4,
    "^",
    "d",
    colors[2],
    colors[3],
)
plot_data(
    axs[1, 0],
    discussion_levels,
    reflection_rate_basic,
    reflection_rate_advanced,
    label_5,
    ">",
    "<",
    colors[1],
    colors[2],
)
plot_data(
    axs[1, 1],
    discussion_levels,
    critique_rate_basic,
    critique_rate_advanced,
    label_6,
    "p",
    "*",
    colors[3],
    colors[0],
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_239.pdf", bbox_inches="tight")
