
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Simulated transportation data
np.random.seed(0)

# Vehicle types and speed ranges
vehicle_types = ["Sedan", "SUV"]
speed = np.array([20, 40, 60, 80, 100, 120])

# Fuel efficiency (km/l)
fuel_efficiency_sedan = np.array([15, 18, 17, 14, 10, 7])
fuel_efficiency_suv = np.array([12, 14, 13, 10, 7, 5])

# Emissions (g/km CO2)
emissions_sedan = np.array([120, 110, 115, 130, 160, 200])
emissions_suv = np.array([150, 140, 150, 175, 210, 250])

# Axes Limits and Labels
xlabel_value = "Speed (km/h)"
ylabel_value_fuel = "Fuel Efficiency (km/l)"
ylabel_value_emissions = "Emissions (g/km CO2)"

# Labels
label_fuel_efficiency = "Fuel Efficiency"
label_emissions = "Emissions"

# Plot Titles
title_fuel_efficiency = "Fuel Efficiency vs. Speed"
title_emissions = "Emissions vs. Speed"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with a 2x2 grid
fig, axs = plt.subplots(2, 2, figsize=(12, 9))

# Custom colors for the plots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Function to plot the data
def plot_data(ax, x, y1, y2, title, ylabel, labels, marker1, marker2, color1, color2):
    ax.plot(
        x,
        y1,
        marker=marker1,
        markersize=8,
        linewidth=2,
        color=color1,
        label=f"{labels[0]} ({vehicle_types[0]})",
    )
    ax.plot(
        x,
        y2,
        marker=marker2,
        markersize=8,
        linewidth=2,
        color=color2,
        label=f"{labels[1]} ({vehicle_types[1]})",
    )
    ax.set_title(title, fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel, fontsize=12)
    ax.legend(loc="best", fontsize=10, frameon=True, shadow=True)
    ax.grid(True, linestyle="--", alpha=0.5)

# Assigning data to each subplot
plot_data(
    axs[0, 0],
    speed,
    fuel_efficiency_sedan,
    fuel_efficiency_suv,
    title_fuel_efficiency,
    ylabel_value_fuel,
    [label_fuel_efficiency, label_fuel_efficiency],
    "o",
    "s",
    colors[0],
    colors[1],
)
plot_data(
    axs[0, 1],
    speed,
    emissions_sedan,
    emissions_suv,
    title_emissions,
    ylabel_value_emissions,
    [label_emissions, label_emissions],
    "^",
    "d",
    colors[2],
    colors[3],
)

# Adding more data plots for thorough representation
plot_data(
    axs[1, 0],
    speed,
    fuel_efficiency_suv,
    fuel_efficiency_sedan,
    title_fuel_efficiency,
    ylabel_value_fuel,
    [label_fuel_efficiency, label_fuel_efficiency],
    "v",
    "x",
    colors[1],
    colors[0],
)
plot_data(
    axs[1, 1],
    speed,
    emissions_suv,
    emissions_sedan,
    title_emissions,
    ylabel_value_emissions,
    [label_emissions, label_emissions],
    "p",
    "*",
    colors[3],
    colors[2],
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plots
plt.tight_layout()
plt.savefig("line_240.pdf", bbox_inches="tight")
