
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# New domain data: Simulated temperature changes over a year for two cities
months = np.linspace(1, 12, 200)
city1_data = 20 + 10 * np.sin((months - 2) * np.pi / 6) + np.random.normal(0, 1, 200)
city2_data = 22 + 8 * np.sin((months - 2) * np.pi / 6) + np.random.normal(0, 1, 200)

# Axes Limits and Labels
xlabel_value = "Month"
ylabel_value = "Temperature (°C)"
ylim_values = [5, 35]

# Labels
labels = ["City A", "City B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a 1x2 subplot layout
fig, axs = plt.subplots(1, 2, figsize=(12, 5))

colors = ["#008080", "#FF7F50"]  # Teal and Coral colors for the lines

# Plot the data in each subplot
for i, ax in enumerate(axs.flat):
    ax.plot(
        months,
        city1_data * (1 + 0.05 * np.random.randn(1)),
        label=labels[0],
        color=colors[0],
        linestyle="--",
        marker="o",
        markersize=3,
        linewidth=2,
    )
    ax.plot(
        months,
        city2_data * (1 + 0.05 * np.random.randn(1)),
        label=labels[1],
        color=colors[1],
        linestyle="-.",
        marker="x",
        markersize=3,
        linewidth=2,
    )
    ax.set_title(f"Temperature Trends {i+1}")
    ax.set_xlabel(xlabel_value)
    ax.set_ylabel(ylabel_value)
    ax.set_ylim(ylim_values)  # Ensure consistent y-axis limits
    ax.grid(True, linestyle='--', alpha=0.7)  # Add grid lines
    ax.legend(loc="upper right", frameon=True)  # Add a legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_244.pdf", bbox_inches="tight")
