
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
# Simulating stock prices for two companies over a certain period
iterations = np.linspace(0, 200, 50)
company_a_stock = 100 * (1 + np.random.normal(0, 0.02, 50)).cumprod()
company_b_stock = 100 * (1 + np.random.normal(0, 0.025, 50)).cumprod()

# Axes Limits and Labels
xlabel_value = "Time (Days)"
ylabel_value = "Stock Price ($)"
ylim_values = [60, 150]

# Labels
label_Company_A = "Company A"
label_Company_B = "Company B"

# Titles
title = "Stock Prices Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Customization options
color_a = "forestgreen"
color_b = "darkorange"
marker_a = "^"
marker_b = "s"
style_a = "--"
style_b = "-."

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the data
ax.plot(
    iterations,
    company_a_stock,
    label=label_Company_A,
    color=color_a,
    marker=marker_a,
    markersize=6,
    linestyle=style_a,
    linewidth=2,
)
ax.plot(
    iterations,
    company_b_stock,
    label=label_Company_B,
    color=color_b,
    marker=marker_b,
    markersize=6,
    linestyle=style_b,
    linewidth=2,
)

# Enhance the plot with a title, labels, and legend
ax.set_title(title, fontsize=14, fontweight='bold')
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Add a legend to the plot
ax.set_ylim(ylim_values)
ax.legend(loc="upper left", frameon=True, shadow=True, fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Save the plot
plt.savefig("line_245.pdf", bbox_inches="tight")
