
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
weeks = np.arange(1, 29)
calories_burned = np.sin(2 * np.pi * weeks / len(weeks)) * 200 + 1500 + np.random.normal(0, 50, len(weeks))
steps_taken = np.cos(3 * np.pi * weeks / len(weeks)) * 2000 + 10000 + np.random.normal(0, 500, len(weeks))

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value_1 = "Calories Burned"
ylabel_value_2 = "Steps Taken"
ylim_values_calories = [1000, 2200]
ylim_values_steps = [6000, 13000]

# Labels
label_1 = "Calories Burned"
label_2 = "Steps Taken"

# Titles
title = "Fitness Tracking: Calories Burned and Steps Taken Over Weeks"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Plot the data on the primary y-axis (Calories Burned)
color = "seagreen"
ax1.set_xlabel(xlabel_value)
ax1.set_ylabel(ylabel_value_1, color=color)
ax1.plot(weeks, calories_burned, label=label_1, color=color, marker="o", linestyle="-")
ax1.tick_params(axis="y", labelcolor=color)
ax1.set_ylim(ylim_values_calories)

# Create a secondary y-axis and plot the data (Steps Taken)
ax2 = ax1.twinx()
color = "darkorange"
ax2.set_ylabel(ylabel_value_2, color=color)
ax2.plot(weeks, steps_taken, label=label_2, color=color, marker="x", linestyle="--")
ax2.tick_params(axis="y", labelcolor=color)
ax2.set_ylim(ylim_values_steps)

# Add a legend to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Customize the plot with a title, grid, and background color
ax1.set_facecolor("whitesmoke")
ax1.grid(True, which="both", linestyle="--", linewidth=0.5, alpha=0.7)

# Set the title
plt.title(title, fontsize=16)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_248.pdf", bbox_inches="tight")
