
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

weeks = np.arange(1, 29)
heart_rate = 70 + 5 * np.sin(2 * np.pi * weeks / len(weeks)) + np.random.normal(0, 2, len(weeks))
blood_pressure = 120 + 8 * np.cos(3 * np.pi * weeks / len(weeks)) + np.random.normal(0, 3, len(weeks))

# Calculate the upper and lower bounds for the data
heart_rate_upper = heart_rate + 3
heart_rate_lower = heart_rate - 3
blood_pressure_upper = blood_pressure + 5
blood_pressure_lower = blood_pressure - 5

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Health Metrics"

# Labels
label_heart_rate = "Heart Rate"
label_blood_pressure = "Blood Pressure"

# Titles
title = "Heart Rate and Blood Pressure Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 5))

# Plot the heart rate data line and fill the confidence interval
ax.plot(
    weeks,
    heart_rate,
    label=label_heart_rate,
    color="green",
    marker="o",
    linestyle="-",
    linewidth=2,
)
ax.fill_between(
    weeks, heart_rate_lower, heart_rate_upper, color="green", alpha=0.3
)

# Plot the blood pressure data line and fill the confidence interval
ax.plot(
    weeks,
    blood_pressure,
    label=label_blood_pressure,
    color="red",
    marker="x",
    linestyle="--",
    linewidth=2,
)
ax.fill_between(weeks, blood_pressure_lower, blood_pressure_upper, color="red", alpha=0.3)

# Customize the plot with labels, title, and legend
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=16)
ax.legend(fontsize=10)

# Add a grid to the plot
ax.grid(True, linestyle="--", linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_251.pdf", bbox_inches="tight")
