
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
weeks = np.arange(1, 29)
data1 = np.clip(1 / (1 + np.exp(-0.3 * (weeks - 15))) + np.random.normal(0, 0.05, len(weeks)), 0, 1)
data2 = np.clip(1 / (1 + np.exp(-0.2 * (weeks - 10))) + np.random.normal(0, 0.05, len(weeks)), 0, 1)
data3 = np.clip(1 / (1 + np.exp(-0.25 * (weeks - 20))) + np.random.normal(0, 0.05, len(weeks)), 0, 1)

# Axes Limits and Labels
xlabel_value = "Weeks"
ylabel_value = "Adoption Level"

# Labels
label_1 = "Technology A"
label_2 = "Technology C"
label_legend = ["Technology A", "Technology B with Gradient", "Technology C"]

# Titles
title = "Technology Adoption Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(12, 8))

# Plot the data series 1
ax.plot(weeks, data1, label=label_1, color="#1f77b4", linewidth=3, marker='o')

# Plot the data series 2 with a gradient color
for i in range(len(weeks) - 1):
    ax.plot(
        weeks[i : i + 2],
        data2[i : i + 2],
        linestyle="-",
        linewidth=3,
        color=plt.cm.plasma(i / len(weeks)),
    )

# Plot the data series 3
ax.plot(weeks, data3, label=label_2, color="#ff7f0e", linestyle="--", linewidth=3, marker='s')

# Customize the plot with labels, title, and legend
ax.set_title(title, fontsize=18)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Add a legend to the plot
custom_lines = [
    plt.Line2D([0], [0], color="#1f77b4", lw=4, marker='o'),
    plt.Line2D([0], [0], color="purple", lw=4),
    plt.Line2D([0], [0], color="#ff7f0e", lw=4, linestyle="--", marker='s'),
]
ax.legend(
    custom_lines,
    label_legend,
    fontsize=12,
)

# Add a grid to the plot
ax.set_facecolor("whitesmoke")
ax.grid(True, which="both", linestyle=":", linewidth=0.75, color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_259.pdf", bbox_inches="tight")
