
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# New data simulating climate change awareness trends over time

years = list(range(2010, 2020))
awareness_campaign1 = [40.5, 45.2, 47.8, 50.3, 60.1, 65.4, 70.7, 73.8, 77.9, 80.4]
awareness_campaign2 = [30.1, 35.4, 37.6, 42.0, 48.5, 53.0, 58.2, 64.9, 68.4, 72.0]
awareness_campaign3 = [20.0, 25.3, 27.1, 32.4, 35.8, 38.5, 42.7, 46.3, 50.2, 53.6]
awareness_campaign4 = [10.5, 15.2, 18.3, 22.4, 25.5, 28.7, 32.1, 35.4, 38.5, 40.9]

# Labels and plot types
line_label_campaign1 = "Campaign 1"
line_label_campaign2 = "Campaign 2"
line_label_campaign3 = "Campaign 3"
line_label_campaign4 = "Campaign 4"

# Plot configuration
xlim_values = [2010, 2019]
ylim_values = [0, 100]
xlabel_value = "Year"
ylabel_value = "Awareness Level (%)"
xticks_values = np.arange(2010, 2020, 1)
yticks_values = np.arange(0, 101, 10)
xtickslabel_values = None  # Not explicitly set in the code
ytickslabel_values = None  # Not explicitly set in the code
title_value = None  # Not explicitly set in the code
axhiline_values = None  # Not explicitly set in the code
axvline_values = None  # Not explicitly set in the code

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 6))

plt.plot(
    years,
    awareness_campaign1,
    marker="o",
    markersize=8,
    color="#007f5f",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_campaign1,
    linewidth=2.5,
    linestyle="-",
)
plt.plot(
    years,
    awareness_campaign2,
    marker="s",
    markersize=8,
    color="#2b9348",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_campaign2,
    linewidth=2.5,
    linestyle="--",
)
plt.plot(
    years,
    awareness_campaign3,
    marker="^",
    markersize=8,
    color="#55a630",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_campaign3,
    linewidth=2.5,
    linestyle="-.",
)
plt.plot(
    years,
    awareness_campaign4,
    marker="D",
    markersize=8,
    color="#80b918",
    clip_on=False,
    zorder=10,
    mfc="w",
    mew=2,
    label=line_label_campaign4,
    linewidth=2.5,
    linestyle=":",
)

# Customize the plot with labels, title, and legend
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit

# Customize the x-axis ticks
plt.xticks(xticks_values)  # Ticks from 1 to 20, interval of 1
plt.xlim(xlim_values)  # Slightly beyond 1 and 20 for a margin

# Add a grid to the plot
plt.xlabel(xlabel_value, fontsize=16)
plt.ylabel(ylabel_value, fontsize=16)
plt.tick_params(axis="x", which="both", length=0)
# Add a title to the plot
plt.legend(
    frameon=False,
    fontsize=12,
    loc="upper right",
    borderpad=1,
    ncol=4,
    bbox_to_anchor=(1, 1.1),
)

# Add a grid to the plot
plt.grid(True, linestyle="-", linewidth=0.5, axis="y")

# Set the background color of the plot
ax = plt.gca()
ax.set_facecolor(
    mcolors.LinearSegmentedColormap.from_list("custom", ["#d1e7e5", "#ffffff"])(0.8)
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_261.pdf", bbox_inches="tight")
