
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(42)  # For reproducibility

# Simulate the data for technology trends
tasks = np.arange(1, 11)
ai_trend = np.linspace(80, 90, 10) + np.random.normal(0, 2, 10)
blockchain_trend = np.linspace(70, 85, 10) + np.random.normal(0, 3, 10)
cloud_trend = np.linspace(65, 75, 10) + np.random.normal(0, 2, 10)
iot_trend = np.linspace(50, 65, 10) + np.random.normal(0, 3, 10)

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Adoption/Performance (%)"
ylim_values = [0, 100]

# Labels
label_AI = "AI"
label_Blockchain = "Blockchain"
label_Cloud = "Cloud Computing"
label_IoT = "IoT"

# Titles
title_1 = "Adoption/Performance Trends: AI vs Blockchain"
title_2 = "Adoption/Performance Trends: Cloud vs IoT"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Define new colors
colors = {
    "ai": "#1f77b4",
    "blockchain": "#ff7f0e",
    "cloud": "#2ca02c",
    "iot": "#d62728"
}

# Plot the data in each subplot
ax1.plot(
    tasks,
    ai_trend,
    marker="o",
    markersize=7,
    color=colors["ai"],
    mfc="w",
    mew=2,
    label=label_AI,
    linestyle='-',
    linewidth=2,
)
ax1.plot(
    tasks,
    blockchain_trend,
    marker="s",
    markersize=7,
    color=colors["blockchain"],
    mfc="w",
    mew=2,
    label=label_Blockchain,
    linestyle='--',
    linewidth=2,
)
ax1.set_title(title_1, fontsize=14)
ax1.set_xlabel(xlabel_value, fontsize=12)
ax1.set_ylabel(ylabel_value, fontsize=12)
ax1.set_ylim(ylim_values)
ax1.set_xticks(xticks_values)
ax1.legend(fontsize=10)
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    tasks,
    cloud_trend,
    marker="d",
    markersize=7,
    color=colors["cloud"],
    mfc="w",
    mew=2,
    label=label_Cloud,
    linestyle='-.',
    linewidth=2,
)
ax2.plot(
    tasks,
    iot_trend,
    marker="^",
    markersize=7,
    color=colors["iot"],
    mfc="w",
    mew=2,
    label=label_IoT,
    linestyle=':',
    linewidth=2,
)
ax2.set_title(title_2, fontsize=14)
ax2.set_xlabel(xlabel_value, fontsize=12)
ax2.set_ylabel(ylabel_value, fontsize=12)
ax2.set_ylim(ylim_values)
ax2.set_xticks(xticks_values)
ax2.legend(fontsize=10)
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_263.pdf", bbox_inches="tight")
