
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for four cities over 10 months
months = np.arange(1, 11)
city1 = np.linspace(30, 60, 10) + np.random.normal(0, 5, 10)
city2 = np.linspace(25, 55, 10) + np.random.normal(0, 5, 10)
city3 = np.linspace(20, 50, 10) + np.random.normal(0, 5, 10)
city4 = np.linspace(15, 45, 10) + np.random.normal(0, 5, 10)

# Axes Limits and Labels
xlabel_value = "Month"
xticks_values = np.arange(1, 11, 1)

ylabel_value = "Average Temperature (°C)"
ylim_values = [0, 70]

# Labels
label_City1 = "City 1"
label_City2 = "City 2"
label_City3 = "City 3"
label_City4 = "City 4"

# Titles
title_1 = "Temperature Trends: City 1 vs City 2"
title_2 = "Temperature Trends: City 3 vs City 4"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(8, 3))

# Plot the data in each subplot
ax1.plot(
    months,
    city1,
    marker="o",
    markersize=7,
    color="#1f77b4",
    mfc="w",
    mew=2,
    label=label_City1,
    linewidth=2,
)
ax1.plot(
    months,
    city2,
    marker="s",
    markersize=7,
    color="#ff7f0e",
    mfc="w",
    mew=2,
    label=label_City2,
    linewidth=2,
)
ax1.set_title(title_1, fontsize=12)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value, fontsize=14)
ax1.set_ylim(ylim_values)
ax1.set_xticks(xticks_values)
ax1.legend()
ax1.grid(True, linestyle="--", alpha=0.6)

ax2.plot(
    months,
    city3,
    marker="^",
    markersize=7,
    color="#2ca02c",
    mfc="w",
    mew=2,
    label=label_City3,
    linewidth=2,
)
ax2.plot(
    months,
    city4,
    marker="v",
    markersize=7,
    color="#d62728",
    mfc="w",
    mew=2,
    label=label_City4,
    linewidth=2,
)
ax2.set_title(title_2, fontsize=12)
ax2.set_xlabel(xlabel_value, fontsize=14)
ax2.set_ylabel(ylabel_value, fontsize=14)
ax2.set_ylim(ylim_values)
ax2.set_xticks(xticks_values)
ax2.legend()
ax2.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_265.pdf", bbox_inches="tight")
