
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data for the plot
years = np.array([2000, 2005, 2010, 2015, 2020])

# Simulated data for book genres
data = {
    "Fiction": (
        np.linspace(0.4, 0.7, 5) + np.random.normal(0, 0.05, 5),
        np.linspace(0.3, 0.6, 5) + np.random.normal(0, 0.05, 5),
    ),
    "Non-Fiction": (
        np.linspace(0.2, 0.5, 5) + np.random.normal(0, 0.05, 5),
        np.linspace(0.1, 0.4, 5) + np.random.normal(0, 0.05, 5),
    ),
    "Mystery": (
        np.linspace(0.3, 0.6, 5) + np.random.normal(0, 0.05, 5),
        np.linspace(0.2, 0.5, 5) + np.random.normal(0, 0.05, 5),
    ),
    "Science Fiction": (
        np.linspace(0.1, 0.4, 5) + np.random.normal(0, 0.05, 5),
        np.linspace(0.15, 0.35, 5) + np.random.normal(0, 0.05, 5),
    ),
}

# Axes Limits and Labels
xlabel_value = "Year"
xticks_values = np.arange(2000, 2025, 5)

ylabel_value = "Popularity Rate"
ylim_values = [0, 1]

# Labels
label_1 = " Series A"
label_2 = " Series B"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(10, 8))

# Plot the data for each genre
colors = ["#2a9d8f", "#e76f51", "#f4a261", "#264653"]
markers = ["o", "v", "s", "D"]

# Plot the data for each genre
for i, (genre, (seriesA, seriesB)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        years,
        seriesA,
        marker=markers[i],
        color=colors[i],
        markerfacecolor=colors[i],
        linewidth=2,
        markersize=6,
        label=f"{genre}{label_1}",
    )
    ax.plot(
        years,
        seriesB,
        marker=markers[i],
        linestyle='--',
        color=colors[i],
        alpha=0.6,
        linewidth=2,
        markersize=6,
        label=f"{genre}{label_2}",
    )
    ax.fill_between(
        years, seriesA - 0.05, seriesA + 0.05, color=colors[i], alpha=0.1
    )
    ax.fill_between(
        years, seriesB - 0.03, seriesB + 0.03, color=colors[i], alpha=0.1
    )
    ax.set_title(f"{genre} Popularity Over Time", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim(ylim_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_266.pdf", bbox_inches="tight")

