
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
years = np.array([2000, 2005, 2010, 2015, 2020, 2025, 2030, 2035, 2040])

# Simulated data for the regions
data = {
    "Region A": (
        np.linspace(5, 15, 9) + np.random.normal(0, 0.5, 9),  # Unemployment Rate
        np.linspace(75, 90, 9) + np.random.normal(0, 0.5, 9), # Literacy Rate
    ),
    "Region B": (
        np.linspace(6, 16, 9) + np.random.normal(0, 0.5, 9),
        np.linspace(70, 85, 9) + np.random.normal(0, 0.5, 9),
    ),
    "Region C": (
        np.linspace(7, 17, 9) + np.random.normal(0, 0.5, 9),
        np.linspace(65, 80, 9) + np.random.normal(0, 0.5, 9),
    ),
    "Region D": (
        np.linspace(5.5, 14.5, 9) + np.random.normal(0, 0.5, 9),
        np.linspace(72, 87, 9) + np.random.normal(0, 0.5, 9),
    ),
}

# Axes Limits and Labels
xlabel_value = "Years"
xticks_values = np.arange(2000, 2050, 5)

ylabel_value = "Percentage"
ylim_values = [0, 100]

# Labels
label_1 = " Unemployment Rate"
label_2 = " Literacy Rate"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(10, 8))

# Plot the data for each region
colors = ["#1f77b4", "#ff7f0e"]
markers = ["d", "^"]

# Plot the data for each region
for i, (key, (series1, series2)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        years,
        series1,
        marker=markers[0],
        color=colors[0],
        markerfacecolor=colors[0],
        linewidth=2,
        markersize=6,
        linestyle='--',
        label=f"{key}{label_1}",
    )
    ax.plot(
        years,
        series2,
        marker=markers[1],
        color=colors[1],
        markerfacecolor=colors[1],
        linewidth=2,
        markersize=6,
        linestyle='-',
        label=f"{key}{label_2}",
    )
    ax.fill_between(
        years, series1 - 0.5, series1 + 0.5, color=colors[0], alpha=0.1
    )
    ax.fill_between(
        years, series2 - 0.5, series2 + 0.5, color=colors[1], alpha=0.1
    )
    ax.set_title(f"{key} Metrics over Time", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_value, fontsize=12)
    ax.set_ylim(ylim_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle='--', linewidth=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_267.pdf", bbox_inches="tight")
