
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
iterations = np.array([0, 250, 500, 750, 1000, 1250, 1500, 1750, 2000])

# Simulated data for the car models
data = {
    "car_model_1": (
        np.linspace(60, 120, 9) + np.random.normal(0, 5, 9),  # Average Speed in km/h
        np.linspace(15, 25, 9) + np.random.normal(0, 1, 9),   # Fuel Efficiency in km/l
    ),
    "car_model_2": (
        np.linspace(70, 130, 9) + np.random.normal(0, 5, 9),
        np.linspace(14, 24, 9) + np.random.normal(0, 1, 9),
    ),
    "car_model_3": (
        np.linspace(65, 125, 9) + np.random.normal(0, 5, 9),
        np.linspace(13, 23, 9) + np.random.normal(0, 1, 9),
    ),
    "car_model_4": (
        np.linspace(75, 135, 9) + np.random.normal(0, 5, 9),
        np.linspace(16, 26, 9) + np.random.normal(0, 1, 9),
    ),
}

# Axes Limits and Labels
xlabel_value = "Iterations"
xticks_values = np.arange(0, 2250, 250)

ylabel_1_value = "Average Speed (km/h)"
ylabel_2_value = "Fuel Efficiency (km/l)"
ylim_1_values = [50, 140]
ylim_2_values = [10, 30]

# Labels
label_1 = " - Avg Speed"
label_2 = " - Fuel Efficiency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
plt.figure(figsize=(12, 10))

# Plot the data for each car model
colors = ["#1f77b4", "#2ca02c", "#ff7f0e", "#d62728"]
markers = ["o", "s", "^", "d"]

# Plot the data for each car model
for i, (key, (series1, series2)) in enumerate(data.items()):
    ax = plt.subplot(2, 2, i + 1)
    ax.plot(
        iterations,
        series1,
        marker=markers[0],
        color=colors[i],
        markerfacecolor=colors[i],
        linewidth=2,
        markersize=6,
        label=f"{key}{label_1}",
    )
    ax.plot(
        iterations,
        series2,
        marker=markers[1],
        color=colors[i],
        markerfacecolor=colors[i],
        linestyle='--',
        linewidth=2,
        markersize=6,
        label=f"{key}{label_2}",
    )
    ax.fill_between(
        iterations, series1 - 5, series1 + 5, color=colors[i], alpha=0.1
    )
    ax.fill_between(
        iterations, series2 - 2, series2 + 2, color=colors[i], alpha=0.1
    )
    ax.set_title(f"{key} Performance", fontsize=14)
    ax.set_xlabel(xlabel_value, fontsize=12)
    ax.set_ylabel(ylabel_1_value if i % 2 == 0 else ylabel_2_value, fontsize=12)
    ax.set_ylim(ylim_1_values if i % 2 == 0 else ylim_2_values)
    ax.set_xticks(xticks_values)
    ax.legend()
    ax.grid(True, linestyle="--", linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()

# Show the plot
plt.savefig("line_268.pdf", bbox_inches="tight")
