
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for the plot
fertilizer_amount = np.array([50, 100, 150, 200, 250, 300, 350])
wheat_yield = np.clip(
    np.linspace(20, 40, len(fertilizer_amount)) + np.random.normal(0, 1, len(fertilizer_amount)),
    20,
    None,
)
corn_yield = np.clip(
    np.linspace(30, 50, len(fertilizer_amount)) + np.random.normal(0, 1.5, len(fertilizer_amount)),
    30,
    None,
)
wheat_constant_yield = [25] * len(fertilizer_amount)
corn_constant_yield = [35] * len(fertilizer_amount)

# Axes Limits and Labels
xlabel_value = "Fertilizer Usage (kg/ha)"
ylabel_value_1 = "Wheat Yield (ton/ha)"
ylabel_value_2 = "Corn Yield (ton/ha)"
ylim_values_1 = [15, 45]
ylim_values_2 = [25, 55]
yticks_values_1 = range(15, 46, 5)
yticks_values_2 = range(25, 56, 5)

# Labels
label_1 = "Wheat Yield"
label_2 = "Corn Yield"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(6, 5))

# Wheat and Corn Yield plots
(wheat_line,) = ax1.plot(
    fertilizer_amount,
    wheat_yield,
    "s-",
    color="#2ca02c",
    label=label_1,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#2ca02c")
ax1.tick_params(
    axis="y", labelcolor="#2ca02c", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

ax2 = ax1.twinx()
(corn_line,) = ax2.plot(
    fertilizer_amount,
    corn_yield,
    "D-",
    color="#ffdd44",
    label=label_2,
    markersize=10,
    linewidth=3,
    mec="black",
)
ax2.set_ylabel(ylabel_value_2, color="#ffdd44", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#ffdd44", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Wheat and Corn constant yield
ax1.axhline(y=25, color="#2ca02c", linestyle=":", linewidth=2)
ax1.axhline(y=35, color="#ffdd44", linestyle="--", linewidth=2)

# Custom legend for the plot
wheat_legend = Line2D([0], [0], color="black", linestyle=":", linewidth=2, label="Avg Wheat")
corn_legend = Line2D([0], [0], color="black", linestyle="--", linewidth=2, label="Avg Corn")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[wheat_legend, corn_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig("line_270.pdf", bbox_inches="tight")
