
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for the plot
sessions = np.array([2, 3, 4, 5, 6, 7, 8])
mock_exam_scores = np.clip(
    np.linspace(70, 90, len(sessions)) + np.random.normal(0, 2, len(sessions)),
    70,
    100,
)
sat_scores = np.clip(
    np.linspace(1200, 1500, len(sessions)) + np.random.normal(0, 30, len(sessions)),
    1200,
    1600,
)
class_avg_scores = [85] * len(sessions)  # Class Average constant scores
state_avg_scores = [1400] * len(sessions)  # State Average constant scores

# Axes Limits and Labels
xlabel_value = "Number of study sessions"

ylabel_value_1 = "Mock Exam Scores"
ylabel_value_2 = "SAT Scores"
ylim_values_1 = [65, 100]
ylim_values_2 = [1150, 1600]
yticks_values_1 = range(70, 101, 5)
yticks_values_2 = range(1200, 1601, 100)

# Labels
label_1 = "Mock Exam (score)"
label_2 = "SAT (score)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Mock Exam and SAT Scores plots
(mock_exam_line,) = ax1.plot(
    sessions,
    mock_exam_scores,
    "o-",
    color="#2E8B57",
    label=label_1,
    markersize=8,
    linewidth=2,
    mec="black",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#2E8B57")
ax1.tick_params(
    axis="y", labelcolor="#2E8B57", direction="in", rotation=90, labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

ax2 = ax1.twinx()
(sat_line,) = ax2.plot(
    sessions,
    sat_scores,
    "s-",
    color="#4B0082",
    label=label_2,
    markersize=8,
    linewidth=2,
    mec="black",
)
ax2.set_ylabel(ylabel_value_2, color="#4B0082", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#4B0082", direction="in", rotation=90, labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Class and State Average constant scores
ax1.axhline(y=85, color="#2E8B57", linestyle=":", linewidth=2)
ax1.axhline(y=1400, color="#4B0082", linestyle="--", linewidth=2)

# Custom legend for the plot
class_avg_legend = Line2D([0], [0], color="black", linestyle=":", linewidth=2, label="Class Avg")
state_avg_legend = Line2D([0], [0], color="black", linestyle="--", linewidth=2, label="State Avg")

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[class_avg_legend, state_avg_legend],
    loc="upper left",
    ncol=2,
    fontsize=14,
    edgecolor="black",
)
ax1.add_artist(first_legend)

# ===================
# Part 4: Saving Output
# ===================
# Add the second legend to the plot
plt.tight_layout()
plt.savefig("line_271.pdf", bbox_inches="tight")
