
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the plot
years = np.arange(2013, 2023)
traditional_classroom = np.clip(
    np.linspace(80, 70, len(years)) + np.random.normal(0, 2, len(years)),
    65,
    85,
)
online_learning = np.clip(
    np.linspace(15, 40, len(years)) + np.random.normal(0, 2, len(years)),
    10,
    50,
)
flipped_classroom = np.clip(
    np.linspace(10, 25, len(years)) + np.random.normal(0, 1, len(years)),
    5,
    30,
)
project_based_learning = np.clip(
    np.linspace(20, 35, len(years)) + np.random.normal(0, 1.5, len(years)),
    15,
    40,
)

# Axes Limits and Labels
xlabel_value = "Years"
ylabel_value_1 = "Percentage of Adoption (%)"
ylabel_value_2 = "Percentage of Adoption (%)"
ylim_values_1 = [0, 90]
ylim_values_2 = [0, 50]
yticks_values_1 = np.arange(0, 100, 10)
yticks_values_2 = np.arange(0, 55, 10)

# Labels
label_1 = "Traditional Classroom"
label_2 = "Online Learning"
label_3 = "Flipped Classroom"
label_4 = "Project-Based Learning"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax1 = plt.subplots(figsize=(10, 8))

# Traditional classroom and Online learning plots
(traditional_line,) = ax1.plot(
    years,
    traditional_classroom,
    color="#1f78b4",
    label=label_1,
    markersize=8,
    linewidth=2,
    mec="black",
    linestyle="-",
    marker="o",
)
ax1.set_xlabel(xlabel_value, fontsize=14)
ax1.set_ylabel(ylabel_value_1, fontsize=14, color="#1f78b4")
ax1.tick_params(
    axis="y", labelcolor="#1f78b4", direction="in", labelsize=12
)
ax1.tick_params(axis="x", direction="in", labelsize=12)
ax1.set_yticks(yticks_values_1)
ax1.set_ylim(ylim_values_1)

# Create a secondary y-axis for Online Learning
ax2 = ax1.twinx()
(online_line,) = ax2.plot(
    years,
    online_learning,
    color="#33a02c",
    label=label_2,
    markersize=8,
    linewidth=2,
    mec="black",
    linestyle="--",
    marker="s",
)
ax2.set_ylabel(ylabel_value_2, color="#33a02c", fontsize=14)
ax2.tick_params(
    axis="y", labelcolor="#33a02c", direction="in", labelsize=12
)
ax2.set_yticks(yticks_values_2)
ax2.set_ylim(ylim_values_2)

# Flipped classroom and Project-based learning
ax1.plot(
    years, 
    flipped_classroom, 
    color="#ff7f00", 
    linewidth=2, 
    linestyle=":", 
    marker="^", 
    markersize=8, 
    label=label_3
)
ax1.plot(
    years, 
    project_based_learning, 
    color="#6a3d9a", 
    linewidth=2, 
    linestyle="-.", 
    marker="*", 
    markersize=8, 
    label=label_4
)

# Custom legend for the plot
traditional_legend = Line2D(
    [0], [0], color="#1f78b4", linestyle="-", linewidth=2, marker="o", markersize=8, label=label_1
)
online_legend = Line2D(
    [0], [0], color="#33a02c", linestyle="--", linewidth=2, marker="s", markersize=8, label=label_2
)
flipped_legend = Line2D(
    [0], [0], color="#ff7f00", linestyle=":", linewidth=2, marker="^", markersize=8, label=label_3
)
project_legend = Line2D(
    [0], [0], color="#6a3d9a", linestyle="-.", linewidth=2, marker="*", markersize=8, label=label_4
)

# Add the legend to the plot
first_legend = ax1.legend(
    handles=[traditional_legend, online_legend], loc="upper left", fontsize=12, edgecolor="black"
)
ax1.add_artist(first_legend)  # Add the first legend back to the plot
second_legend = ax1.legend(
    handles=[flipped_legend, project_legend], loc="upper right", fontsize=12, edgecolor="black"
)  # Add the second legend

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_273.pdf", bbox_inches="tight")
