
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data for the plot
import numpy as np

np.random.seed(0)
years = np.arange(2010, 2020)
num_tourists = np.clip(
    np.sin(np.linspace(0, 2 * np.pi, len(years))) * 500000
    + 2000000
    + np.random.normal(0, 50000, len(years)),
    1000000,
    3000000,
)
revenue = np.clip(
    np.cos(np.linspace(0, 2 * np.pi, len(years))) * 1000000
    + 5000000
    + np.random.normal(0, 200000, len(years)),
    3000000,
    7000000,
)

# Axes Limits and Labels
xlabel_value = "Year"

ylabel_value_1 = "Number of Tourists"
ylabel_value_2 = "Revenue Generated ($)"

# Labels
label_1 = "Number of Tourists"
label_2 = "Revenue Generated"

label = "Revenue Threshold"

# Threshold value
threshold = 6000000

# Annotation highlight
highlight = [2013, 2016, 2019]  # Years to highlight

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plotting number of tourists
(tourists_line,) = ax.plot(
    years,
    num_tourists,
    "o-",
    color="#ff7f0e",
    label=label_1,
    markersize=8,
    linewidth=2,
)
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value_1, fontsize=14)
ax.tick_params(axis="y", direction="in", labelsize=12)
ax.tick_params(axis="x", direction="in", labelsize=12)

# Create a secondary y-axis for Revenue
(revenue_line,) = ax.plot(
    years,
    revenue,
    "s--",
    color="#1f77b4",
    label=label_2,
    markersize=8,
    linewidth=2,
)

# Add a legend to the plot
ax.axhline(y=threshold, color="red", linestyle="-", linewidth=1.5, label=label)

# Highlight the data points above the threshold
for year in highlight:
    ax.plot(
        year, revenue[np.where(years == year)], "ro"
    )  # Highlight Revenue
    ax.annotate(
        f"Highlight {year}",
        (year, revenue[np.where(years == year)]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
    )

# Customize the plot with labels, title, and legend
ax.legend(fontsize=12)

# Add a grid to the plot
ax.grid(True, linestyle="--", alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout for better spacing and display
plt.tight_layout()
plt.savefig("line_276.pdf", bbox_inches="tight")
