
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for air quality monitoring accuracy over months
months = [1, 2, 3, 4, 5]
method_a = [75, 78, 80, 85, 87]
method_b = [70, 74, 77, 82, 85]
method_c = [65, 70, 74, 79, 83]
method_d = [80, 83, 86, 89, 91]

# Labels and Plot Types
label_method_a = "Classic Monitoring Devices"
label_method_b = "Satellite-based Monitoring"
label_method_c = "Drone Surveillance"
label_method_d = "Ground Sensor Networks"
xlabel_value = "Months"
ylabel_value = "Monitoring Accuracy (%)"

# Axes Limits and Labels
xlim_values = [1, 5]
ylim_values = [60, 100]
xticks_values = np.arange(1, 6, 1)
yticks_values = np.arange(60, 101, 10)
title="Accuracy of Different Air Quality Monitoring Methods Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
plt.figure(figsize=(10, 6))  # Adjusting figure size for better readability

plt.plot(
    months,
    method_a,
    "-D",
    label=label_method_a,
    color="#2E8B57",  # Sea Green
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    method_b,
    "-v",
    label=label_method_b,
    color="#4682B4",  # Steel Blue
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    method_c,
    "-s",
    label=label_method_c,
    color="#8B4513",  # Saddle Brown
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

plt.plot(
    months,
    method_d,
    "-o",
    label=label_method_d,
    color="#32CD32",  # Lime Green
    clip_on=False,
    zorder=10,
    linewidth=2,
    markersize=8,
)

# Set y-axis to only display specific ticks and extend y-axis to leave space at top
plt.yticks(yticks_values)
plt.ylim(ylim_values)  # Adjusted y-axis limit
plt.xticks(xticks_values)
plt.xlim(xlim_values)

# Adding grid, legend, and labels
plt.grid(True, linestyle='--', alpha=0.7)
plt.legend(loc="upper left", bbox_to_anchor=(1.05, 1), ncol=1, frameon=False)
plt.xlabel(xlabel_value)
plt.ylabel(ylabel_value)
plt.title(title, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjusting layout to reduce white space
plt.tight_layout()
plt.savefig("line_72.pdf", bbox_inches="tight")
