
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for education domain
np.random.seed(1)
grade_levels = [1, 2, 3, 4, 5]  # Grade 1 to Grade 5

# Average test scores for three subjects
math_scores = [75, 78, 82, 85, 87]
science_scores = [70, 72, 75, 79, 83]
english_scores = [80, 81, 83, 84, 86]

# Simulating standard deviations for error
math_std = np.random.rand(5) * 2
science_std = np.random.rand(5) * 2
english_std = np.random.rand(5) * 2

# Labels
label_Math = "Math"
label_Science = "Science"
label_English = "English"

# Axes Limits and Labels
xlabel_value = "Grade Level"
ylabel_value = "Average Test Score"
yticks_values = np.arange(65, 91, 5)

# Title and Supertitle
title_value = "Average Test Scores by Grade Level"
supertitle_value = "School Performance Analysis"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting the lines with error bands
plt.figure(figsize=(6, 4))
plt.plot(grade_levels, math_scores, "s-", color="dodgerblue", label=label_Math, linewidth=1.5)
plt.fill_between(
    grade_levels,
    np.array(math_scores) - math_std,
    np.array(math_scores) + math_std,
    color="dodgerblue",
    alpha=0.2,
)

plt.plot(grade_levels, science_scores, "^-", color="darkorange", label=label_Science, linewidth=1.5)
plt.fill_between(
    grade_levels,
    np.array(science_scores) - science_std,
    np.array(science_scores) + science_std,
    color="darkorange",
    alpha=0.2,
)

plt.plot(grade_levels, english_scores, "o-", color="forestgreen", label=label_English, linewidth=1.5)
plt.fill_between(
    grade_levels,
    np.array(english_scores) - english_std,
    np.array(english_scores) + english_std,
    color="forestgreen",
    alpha=0.2,
)

# Labels and title
plt.xlabel(xlabel_value, fontsize=12)
plt.ylabel(ylabel_value, fontsize=12)
plt.xticks(grade_levels)
plt.yticks(yticks_values)
plt.title(title_value, fontsize=14)
plt.suptitle(supertitle_value, fontsize=16)

# Moving axes spines
ax = plt.gca()  # get current axes
ax.spines["left"].set_position(("outward", 10))  # move left y-axis outwards
ax.spines["bottom"].set_position(("outward", 10))  # move bottom x-axis outwards
ax.spines["right"].set_color("none")  # hide the right spine
ax.spines["top"].set_color("none")  # hide the top spine
ax.grid(
    True, which="both", axis="both", color="lightgray", linestyle="--", linewidth=0.5
)

# Legend
plt.legend(loc="upper left", fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot
plt.tight_layout()
plt.savefig("line_75.pdf", bbox_inches="tight")

