
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for plotting
quarters = ["Q1", "Q2", "Q3", "Q4"]  # Update for categorical x-axis
team_a_performance = [75, 85, 78, 88]
team_a_avg = [70, 80, 75, 83]
team_b_performance = [65, 75, 70, 80]
team_b_avg = [60, 70, 65, 78]

# Axes Limits and Labels
xticks_values = range(len(quarters))
ylabel_value = "Performance Score (%)"

# Labels
label_performance = "Performance"
label_avg = "Average"

# Titles
title_team_a = "Team A Performance"
title_team_b = "Team B Performance"

# Texts
text_team_a = "Top Performer"
text_team_b = "Improved Performance"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# Plotting for Team A
ax1.set_xticks(xticks_values)  # Setting categorical x-axis
ax1.plot(
    quarters,
    team_a_performance,
    marker="s",
    color="#FF5733",
    label=label_performance,
    linewidth=3,
    markersize=9,
)
ax1.plot(
    quarters,
    team_a_avg,
    marker="^",
    linestyle="--",
    color="#1F618D",
    label=label_avg,
    linewidth=3,
    markersize=9,
)
ax1.set_title(title_team_a, fontsize=16)
ax1.set_ylabel(ylabel_value, fontsize=16)
ax1.legend(loc="lower left", fontsize=14)
ax1.set_xticklabels(quarters, fontsize=12)
ax1.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax1.annotate(
    text_team_a,
    xy=(2, team_a_performance[2]),
    xytext=(2, team_a_performance[2] + 5),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
)
ax1.text(
    2.5,
    team_a_avg[2] - 5,
    f"{team_a_performance[2]}%",
    ha="left",
    va="center",
    fontsize=12,
    color="black",
)

# Plotting for Team B
ax2.plot(
    quarters,
    team_b_performance,
    marker="o",
    color="#33FF57",
    label=label_performance,
    linewidth=3,
    markersize=9,
)
ax2.plot(
    quarters,
    team_b_avg,
    marker="x",
    linestyle="--",
    color="#8E44AD",
    label=label_avg,
    linewidth=3,
    markersize=9,
)
ax2.set_title(title_team_b, fontsize=16)
ax2.legend(loc="lower left", fontsize=14)
ax2.set_xticklabels(quarters, fontsize=12)
ax2.grid(True, which="both", ls="--", color="grey", linewidth=1, axis="y", alpha=0.5)
ax2.annotate(
    text_team_b,
    xy=(3, team_b_performance[3]),
    xytext=(3, team_b_performance[3] + 5),
    arrowprops=dict(color="green", shrink=0.05, width=1.5, headwidth=8),
)


# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and add common annotation for quarters
plt.tight_layout()
plt.savefig("line_80.pdf", bbox_inches="tight")
